/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.jdbc;

import com.highgo.jdbc.jdbc.HGClob;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class HGClobWriter
extends Writer {
    private HGClob parentClob;
    private long currentPos;

    public HGClobWriter(HGClob currentClob, long position) {
        this.parentClob = currentClob;
        this.currentPos = position;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            return;
        }
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (cbuf == null) {
            return;
        }
        this.write(new String(cbuf));
    }

    @Override
    public void write(String srcStr, int off, int len) throws IOException {
        if (srcStr == null) {
            return;
        }
        try {
            int i = this.parentClob.setString(this.currentPos, srcStr, off, len);
            this.currentPos += (long)i;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    @Override
    public void write(String srcStr) throws IOException {
        if (srcStr == null) {
            return;
        }
        this.write(srcStr, 0, srcStr.length());
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    @Override
    public void close() throws IOException {
        this.checkClosed();
    }

    private void checkClosed() throws IOException {
        if (this.parentClob == null) {
            throw new IOException("Stream is closed");
        }
    }
}

