/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.util;

import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    public static String sendPost(String host, String port, String param) throws SQLException {
        return HttpRequest.sendPost("http://" + host + ":" + port + "/getRecommendedServer", param);
    }

    public static String sendPost(String url, String param) throws SQLException {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (MalformedURLException e) {
            throw new PSQLException(GT.tr("parse URL: {0} error, check url first. ", url), PSQLState.INVALID_PARAMETER_VALUE);
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("hgjdbc send Post to ReCommendedServer {0} get IOException : {1}, can't get the real db server", url, e.getMessage()), PSQLState.IO_ERROR);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String sendGet(String host, String port, String param) throws SQLException {
        return HttpRequest.sendGet("http://" + host + ":" + port + "/getRecommendedServer", param);
    }

    public static String sendGet(String url, String param) throws SQLException {
        BufferedReader in = null;
        String result = "";
        String urlNameString = "";
        try {
            String line;
            urlNameString = url;
            if (param != null && !param.isEmpty()) {
                urlNameString = urlNameString + "?" + param;
            }
            URL realUrl = new URL(urlNameString);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.connect();
            Map<String, List<String>> map = conn.getHeaderFields();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (MalformedURLException e) {
            throw new PSQLException(GT.tr("parse URL: {0} error, check url first. ", url), PSQLState.INVALID_PARAMETER_VALUE);
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("hgjdbc send Get to ReCommendedServer {0} get IOException : {1}, can't get the real db server", url, e.getMessage()), PSQLState.IO_ERROR);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

