/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.query.Condition;
import org.apache.mybatis.jpa.query.Operator;
import org.apache.mybatis.jpa.query.Query;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProvider<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(QueryProvider.class);

    public String filterByQuery(T entity, Query query) {
        _logger.trace("Query \n" + query);
        SQL sql = (SQL)MapperMetadata.buildSelect(entity.getClass()).WHERE(this.buildQuery(query));
        if (query.getGroupBy() != null) {
            sql.GROUP_BY(this.buildQueryGroupBy(query));
        }
        if (query.getOrderBy() != null) {
            sql.ORDER_BY(this.buildQueryOrderBy(query));
        }
        _logger.trace("filter By Query SQL \n" + sql.toString());
        return sql.toString();
    }

    public String buildQuery(Query query) {
        StringBuffer conditionString = new StringBuffer("");
        for (Condition condition : query.getConditions()) {
            condition.setColumn(condition.getColumn().replaceAll("'", "").replaceAll(" ", "").replace(";", ""));
            if (condition.getExpression().equals((Object)Operator.and) || condition.getExpression().equals((Object)Operator.or)) {
                conditionString.append(" ").append(condition.getExpression().getOperator()).append(" ");
                if (condition.getValue() == null || !(condition.getValue() instanceof Query)) continue;
                conditionString.append(" ( ").append(this.buildQuery((Query)condition.getValue())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.like) || condition.getExpression().equals((Object)Operator.notLike)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeLeft)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeRight)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.eq) || condition.getExpression().equals((Object)Operator.notEq) || condition.getExpression().equals((Object)Operator.gt) || condition.getExpression().equals((Object)Operator.ge) || condition.getExpression().equals((Object)Operator.lt) || condition.getExpression().equals((Object)Operator.le)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(this.getConditionValue(condition.getValue()));
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.between) || condition.getExpression().equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(this.getConditionValue(condition.getValue()));
                conditionString.append(" and ");
                conditionString.append(this.getConditionValue(condition.getValue2())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.isNull) || condition.getExpression().equals((Object)Operator.isNotNull)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.in) || condition.getExpression().equals((Object)Operator.notIn)) {
                Object[] objects;
                if (!condition.getValue().getClass().isArray()) continue;
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                conditionString.append(" ( ");
                StringBuffer conditionArray = new StringBuffer();
                Object[] objectArray = objects = (Object[])condition.getValue();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (conditionArray.length() > 0) {
                        conditionArray.append(" , ");
                    }
                    conditionArray.append(this.getConditionValue(object));
                    ++n2;
                }
                conditionString.append(conditionArray);
                conditionString.append(" ) ");
                continue;
            }
            if (!condition.getExpression().equals((Object)Operator.condition)) continue;
            conditionString.append(condition.getColumn().replace(";", ""));
        }
        return conditionString.toString();
    }

    String buildQueryGroupBy(Query query) {
        StringBuffer groupBy = new StringBuffer();
        for (Condition condition : query.getGroupBy()) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(condition.getColumn());
        }
        return groupBy.toString();
    }

    String buildQueryOrderBy(Query query) {
        StringBuffer orderBy = new StringBuffer();
        for (Condition condition : query.getGroupBy()) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(condition.getColumn()).append(" ").append(condition.getValue());
        }
        return orderBy.toString();
    }

    public String getConditionValue(Object value) {
        StringBuffer conditionString = new StringBuffer("");
        String valueType = value.getClass().getSimpleName().toLowerCase();
        if (valueType.equals("string") || valueType.equals("char")) {
            conditionString.append("'").append(String.valueOf(value).replaceAll("'", "")).append("'");
        } else if (valueType.equals("int") || valueType.equals("long") || valueType.equals("integer") || valueType.equals("float") || valueType.equals("double")) {
            conditionString.append("").append(value).append("");
        } else {
            conditionString.append("'").append(String.valueOf(value).replaceAll("'", "")).append("'");
        }
        return conditionString.toString();
    }

    public String query(T entity) {
        SQL sql = MapperMetadata.buildSelect(entity.getClass());
        for (FieldColumnMapper fieldColumnMapper : (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName())) {
            String fieldValue = BeanUtil.getValue(entity, fieldColumnMapper.getFieldName());
            String fieldType = fieldColumnMapper.getFieldType().toLowerCase();
            _logger.trace("ColumnName {} , FieldType {} , value {}", new Object[]{fieldColumnMapper.getColumnName(), fieldType, fieldValue});
            if (fieldValue == null || fieldType.equals("string") && fieldValue.equals("") || fieldType.startsWith("byte") && fieldValue == null || fieldType.equals("int") && fieldValue.equals("0") || fieldType.equals("long") && fieldValue.equals("0") || fieldType.equals("integer") && fieldValue.equals("0") || fieldType.equals("float") && fieldValue.equals("0.0") || fieldType.equals("double") && fieldValue.equals("0.0")) continue;
            sql.WHERE(String.valueOf(fieldColumnMapper.getColumnName()) + " = #{" + fieldColumnMapper.getFieldName() + "}");
        }
        _logger.trace("filter By Entity SQL \n" + sql.toString());
        return sql.toString();
    }
}

