/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindProvider<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(FindProvider.class);

    public String findAll(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.FINDALL_SQL)) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.FINDALL_SQL);
        }
        SQL sql = MapperMetadata.buildSelect(entityClass);
        String findAllSql = sql.toString();
        _logger.trace("Find All SQL \n" + findAllSql);
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.FINDALL_SQL, findAllSql);
        return findAllSql;
    }

    public String find(Map<String, Object> parametersMap) throws Exception {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        Object[] args = (Object[])parametersMap.get(MapperMetadata.QUERY_ARGS);
        int[] argTypes = (int[])parametersMap.get(MapperMetadata.QUERY_ARGTYPES);
        String filterSql = parametersMap.get(MapperMetadata.QUERY_FILTER).toString().trim();
        MapperMetadata.buildColumnList(entityClass);
        if (filterSql.toLowerCase().startsWith("where")) {
            filterSql = filterSql.substring(5);
        }
        if (args == null || args.length == 0) {
            filterSql = StringUtils.lineBreak2Blank(filterSql);
        } else {
            int countMatches = StringUtils.countMatches((CharSequence)filterSql, (CharSequence)"?");
            if (args.length < countMatches) {
                _logger.error("args length {} < parameter placeholder {}", (Object)countMatches, (Object)args.length);
                throw new Exception("args length < parameter placeholder");
            }
            String[] filterSqls = filterSql.split("\\?");
            StringBuffer sqlBuffer = new StringBuffer("");
            int i = 0;
            while (i < args.length) {
                _logger.trace("Find args[{}] {}", (Object)i, args[i]);
                if (argTypes[i] == 12 || argTypes[i] == -9 || argTypes[i] == 1 || argTypes[i] == -15 || argTypes[i] == -1 || argTypes[i] == -16) {
                    sqlBuffer.append(filterSqls[i]).append("'").append(args[i].toString().replaceAll("'", "")).append("'");
                } else {
                    sqlBuffer.append(filterSqls[i]).append(args[i]);
                }
                ++i;
            }
            filterSql = StringUtils.lineBreak2Blank(sqlBuffer.toString());
        }
        SQL sql = (SQL)MapperMetadata.buildSelect(entityClass).WHERE(filterSql);
        String findSql = sql.toString();
        _logger.trace("Find SQL \n" + findSql);
        return findSql;
    }
}

