/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProvider<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(DeleteProvider.class);

    public String remove(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.REMOVE_SQL)) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.REMOVE_SQL);
        }
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(tableName)).WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " = #{" + idFieldColumnMapper.getFieldName() + ",javaType=string,jdbcType=VARCHAR}");
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.REMOVE_SQL, deleteSql);
        _logger.trace("Delete SQL \n" + deleteSql);
        return deleteSql;
    }

    public String batchDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        String keyValue = "";
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue = String.valueOf(keyValue) + ",'" + value + "'";
            _logger.trace("batch delete by id " + value);
        }
        keyValue = keyValue.substring(1).replaceAll(";", "");
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(tableName)).WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " in ( " + keyValue + " )");
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.BATCHDELETE_SQL, deleteSql);
        _logger.trace("Delete SQL \n" + deleteSql);
        return deleteSql;
    }

    public String logicDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        String keyValue = "";
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue = String.valueOf(keyValue) + ",'" + value + "'";
            _logger.trace("logic delete by id " + value);
        }
        keyValue = keyValue.substring(1).replaceAll(";", "");
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(tableName)).SET("status = 9")).WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " in ( " + keyValue + " )");
        String deleteSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + MapperMetadata.SQL_TYPE.LOGICDELETE_SQL, deleteSql);
        _logger.trace("logic Delete SQL \n" + deleteSql);
        return deleteSql;
    }
}

