/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dialect {
    private static final Logger logger = LoggerFactory.getLogger(Dialect.class);
    public static final String DEFAULT_BATCH_SIZE = "20";
    public static final String NO_BATCH = "0";
    public static final String DEFAULT_DIALECT = "mysql";
    protected static HashMap<String, String> dialectMap = new HashMap();

    protected Dialect() {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getLimitString(String query, JpaPage page) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public String getPreparedStatementLimitString(String query, JpaPage page) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPage pagination) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public boolean supportsLimit() {
        return false;
    }

    public static Map<String, String> getDialectMap() {
        return dialectMap;
    }

    public static String getDialect(String dialect) {
        String dialectString = dialectMap.get(dialect);
        if (dialectString == null) {
            dialectString = dialectMap.get(DEFAULT_DIALECT);
        }
        return dialectString;
    }

    static {
        dialectMap.put("db2", "org.dromara.mybatis.jpa.dialect.DB2Dialect");
        dialectMap.put("derby", "org.dromara.mybatis.jpa.dialect.DerbyDialect");
        dialectMap.put(DEFAULT_DIALECT, "org.dromara.mybatis.jpa.dialect.MySQLDialect");
        dialectMap.put("oracle", "org.dromara.mybatis.jpa.dialect.OracleDialect");
        dialectMap.put("postgresql", "org.dromara.mybatis.jpa.dialect.PostgreSQLDialect");
        dialectMap.put("highgo", "org.dromara.mybatis.jpa.dialect.HighgoDialect");
        dialectMap.put("sqlserver", "org.dromara.mybatis.jpa.dialect.SQLServerDialect");
        logger.trace("Dialect Mapper : \n{}", dialectMap);
    }
}

