/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.Operator;

public class Query {
    ArrayList<Condition> conditions = new ArrayList();
    ArrayList<Condition> groupBy;
    ArrayList<Condition> orderBy;
    boolean softDelete = true;

    public static Query builder() {
        return new Query();
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<Condition> getOrderBy() {
        return this.orderBy;
    }

    public void joint() {
        Operator lastJoint;
        if (CollectionUtils.isNotEmpty(this.conditions) && !(lastJoint = this.conditions.get(this.conditions.size() - 1).getExpression()).equals((Object)Operator.AND) && !lastJoint.equals((Object)Operator.OR)) {
            this.and();
        }
    }

    public Query and() {
        this.conditions.add(new Condition(Operator.AND, "", null));
        return this;
    }

    public Query or() {
        this.conditions.add(new Condition(Operator.OR, "", null));
        return this;
    }

    public Query and(Query subQuery) {
        this.conditions.add(new Condition(Operator.AND, "", subQuery));
        return this;
    }

    public Query or(Query subQuery) {
        this.conditions.add(new Condition(Operator.OR, "", subQuery));
        return this;
    }

    public Query eq(String column, Object value) {
        this.eq(true, column, value);
        return this;
    }

    public Query ignoreCase(String column, Object value) {
        this.joint();
        this.conditions.add(new Condition(Operator.IGNORE_CASE, column, value));
        return this;
    }

    public Query eq(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.EQ, column, value));
        }
        return this;
    }

    public Query notEq(String column, Object value) {
        this.notEq(true, column, value);
        return this;
    }

    public Query notEq(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.NOT_EQ, column, value));
        }
        return this;
    }

    public Query in(String column, Object ... value) {
        this.in(true, column, value);
        return this;
    }

    public Query in(boolean expression, String column, Object ... value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.IN, column, value));
        }
        return this;
    }

    public Query notIn(String column, Object ... value) {
        this.notIn(true, column, value);
        return this;
    }

    public Query notIn(boolean expression, String column, Object ... value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.NOT_IN, column, value));
        }
        return this;
    }

    public Query gt(String column, Object value) {
        this.gt(true, column, value);
        return this;
    }

    public Query gt(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.GT, column, value));
        }
        return this;
    }

    public Query ge(String column, Object value) {
        this.ge(true, column, value);
        return this;
    }

    public Query ge(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.GE, column, value));
        }
        return this;
    }

    public Query lt(String column, Object value) {
        this.lt(true, column, value);
        return this;
    }

    public Query lt(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.LT, column, value));
        }
        return this;
    }

    public Query le(String column, Object value) {
        this.le(true, column, value);
        return this;
    }

    public Query le(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.LE, column, value));
        }
        return this;
    }

    public Query like(String column, Object value) {
        this.like(true, column, value);
        return this;
    }

    public Query like(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.LIKE, column, value));
        }
        return this;
    }

    public Query notLike(String column, Object value) {
        this.notLike(true, column, value);
        return this;
    }

    public Query notLike(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.NOT_LIKE, column, value));
        }
        return this;
    }

    public Query likeLeft(String column, Object value) {
        this.likeLeft(true, column, value);
        return this;
    }

    public Query likeLeft(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.LIKE_LEFT, column, value));
        }
        return this;
    }

    public Query likeRight(String column, Object value) {
        this.likeRight(true, column, value);
        return this;
    }

    public Query likeRight(boolean expression, String column, Object value) {
        if (expression) {
            this.joint();
            this.conditions.add(new Condition(Operator.LIKE_RIGHT, column, value));
        }
        return this;
    }

    public Query isNull(String column) {
        this.joint();
        this.conditions.add(new Condition(Operator.IS_NULL, column, null));
        return this;
    }

    public Query isNotNull(String column) {
        this.joint();
        this.conditions.add(new Condition(Operator.IS_NOT_NULL, column, null));
        return this;
    }

    public Query between(String column, Object value1, Object value2) {
        this.joint();
        this.conditions.add(new Condition(Operator.BETWEEN, column, value1, value2));
        return this;
    }

    public Query notBetween(String column, Object value1, Object value2) {
        this.joint();
        this.conditions.add(new Condition(Operator.NOT_BETWEEN, column, value1, value2));
        return this;
    }

    public Query condition(String conditionSql) {
        this.joint();
        this.conditions.add(new Condition(Operator.CONDITION, conditionSql, null));
        return this;
    }

    public Query groupBy(String column) {
        if (CollectionUtils.isEmpty(this.groupBy)) {
            this.groupBy = new ArrayList();
        }
        this.groupBy.add(new Condition(Operator.GROUP, column, ""));
        return this;
    }

    public Query orderBy(String column, String orderType) {
        if (CollectionUtils.isEmpty(this.orderBy)) {
            this.orderBy = new ArrayList();
        }
        this.orderBy.add(new Condition(Operator.ORDER, column, orderType));
        return this;
    }

    public List<Condition> getGroupBy() {
        return this.groupBy;
    }

    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public void setSoftDelete(boolean softDelete) {
        this.softDelete = softDelete;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query [conditions=");
        builder.append(this.conditions);
        builder.append(", groupBy=");
        builder.append(this.groupBy);
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

