/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.builder.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.builder.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(QueryProvider.class);

    public String queryByQuery(Class<?> entityClass, Query query) {
        logger.trace("Query \n{}", (Object)query);
        SQL sql = TableMetadata.buildSelect(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete() && query.isSoftDelete()) {
            sql.WHERE("( %s ) and %s = '%s'".formatted(QueryBuilder.build(query), logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        } else {
            sql.WHERE(QueryBuilder.build(query));
        }
        if (query.getGroupBy() != null) {
            sql.GROUP_BY(QueryBuilder.buildGroupBy(query));
        }
        if (query.getOrderBy() != null) {
            sql.ORDER_BY(QueryBuilder.buildOrderBy(query));
        }
        logger.trace("filter By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String queryByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("LambdaQuery \n{}", lambdaQuery);
        SQL sql = TableMetadata.buildSelect(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete() && lambdaQuery.isSoftDelete()) {
            sql.WHERE("( %s ) and %s = '%s'".formatted(LambdaQueryBuilder.build(lambdaQuery), logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        } else {
            sql.WHERE(LambdaQueryBuilder.build(lambdaQuery));
        }
        if (CollectionUtils.isNotEmpty(lambdaQuery.getGroupBy())) {
            sql.GROUP_BY(LambdaQueryBuilder.buildGroupBy(lambdaQuery));
        }
        if (CollectionUtils.isNotEmpty(lambdaQuery.getOrderBy())) {
            sql.ORDER_BY(LambdaQueryBuilder.buildOrderBy(lambdaQuery));
        }
        logger.trace("filter By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String query(T entity) {
        SQL sql = TableMetadata.buildSelect(entity.getClass());
        for (FieldColumnMapper fieldColumnMapper : FieldMetadata.buildColumnMapper(entity.getClass())) {
            Object fieldValue = BeanUtil.get(entity, fieldColumnMapper.getFieldName());
            String fieldType = fieldColumnMapper.getFieldType().toLowerCase();
            logger.trace("ColumnName {} , FieldType {} , value {}", new Object[]{fieldColumnMapper.getColumnName(), fieldType, fieldValue});
            if (fieldValue == null) {
                logger.trace("skip  {} ({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getColumnName());
                continue;
            }
            if ("string".equals(fieldType) && "".equals(fieldValue) || "byte".startsWith(fieldType) || "Int".equals(fieldType) && "0".equals(fieldValue) || "Long".equals(fieldType) && "0".equals(fieldValue) || "Integer".equals(fieldType) && "0".equals(fieldValue) || "Float".equals(fieldType) && "0.0".equals(fieldValue) || "Double".equals(fieldType) && "0.0".equals(fieldValue)) continue;
            if (fieldColumnMapper.isLogicDelete()) {
                sql.WHERE(fieldColumnMapper.getColumnName() + " = '" + fieldColumnMapper.getSoftDelete().value() + "'");
                continue;
            }
            sql.WHERE(fieldColumnMapper.getColumnName() + " = #{" + fieldColumnMapper.getFieldName() + "}");
        }
        logger.trace("filter By Entity SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String countByQuery(Class<?> entityClass, Query query) {
        logger.trace("count Query \n{}", (Object)query);
        SQL sql = TableMetadata.buildSelectCount(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete() && query.isSoftDelete()) {
            sql.WHERE("( %s ) and %s = '%s'".formatted(QueryBuilder.build(query), logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        } else {
            sql.WHERE(QueryBuilder.build(query));
        }
        logger.trace("count By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String countByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("count LambdaQuery \n{}", lambdaQuery);
        SQL sql = TableMetadata.buildSelectCount(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete() && lambdaQuery.isSoftDelete()) {
            sql.WHERE("( %s ) and %s = '%s'".formatted(LambdaQueryBuilder.build(lambdaQuery), logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        } else {
            sql.WHERE(LambdaQueryBuilder.build(lambdaQuery));
        }
        logger.trace("count By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

