/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.datasource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataSourceContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourceContextHolder.class);
    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal();

    public static void setDataSource(String key) {
        if (key != null) {
            CONTEXT_HOLDER.set(key);
            logger.debug("Set DataSource for current thread: {}", (Object)key);
        } else {
            logger.warn("Attempted to set null DataSource key");
        }
    }

    public static String getDataSource() {
        String key = CONTEXT_HOLDER.get();
        logger.trace("Get DataSource for current thread: {}", (Object)key);
        return key;
    }

    public static void clearDataSource() {
        String currentKey = CONTEXT_HOLDER.get();
        CONTEXT_HOLDER.remove();
        logger.debug("Cleared DataSource for current thread, was: {}", (Object)currentKey);
    }

    public static boolean hasDataSource() {
        return CONTEXT_HOLDER.get() != null;
    }
}

