/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.desktop.endpoint.adapter;

import java.util.HashMap;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.crypto.HexUtils;
import org.maxkey.domain.UserInfo;
import org.maxkey.domain.apps.Apps;
import org.maxkey.domain.apps.AppsDesktopDetails;
import org.maxkey.util.JsonUtils;
import org.maxkey.util.StringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class DesktopDefaultAdapter
extends AbstractAuthorizeAdapter {
    static final Logger _logger = LoggerFactory.getLogger(DesktopDefaultAdapter.class);

    public String generateInfo(UserInfo userInfo, Object app) {
        String parameter;
        AppsDesktopDetails details = (AppsDesktopDetails)app;
        String string = parameter = details.getParameter() == null ? "" : details.getParameter();
        if (details.getUsernameType().equalsIgnoreCase("PARAMETER")) {
            parameter = parameter + " " + details.getUsernameParameter();
            parameter = parameter + " " + details.getAppUser().getRelatedUsername();
        }
        if (details.getPasswordType().equalsIgnoreCase("PARAMETER")) {
            parameter = parameter + " " + details.getPasswordParameter();
            parameter = parameter + " " + details.getAppUser().getRelatedPassword();
        }
        HashMap<String, String> beanMap = new HashMap<String, String>();
        beanMap.put("randomId", new StringGenerator().uuidGenerate());
        beanMap.put("programPath", details.getProgramPath());
        beanMap.put("parameter", details.getParameter());
        beanMap.put("preUsername", details.getPreUsername());
        beanMap.put("usernameType", details.getUsernameType());
        beanMap.put("usernameParameter", details.getUsernameParameter());
        beanMap.put("username", details.getAppUser().getRelatedUsername());
        beanMap.put("prePassword", details.getPrePassword());
        beanMap.put("passwordType", details.getPasswordType());
        beanMap.put("passwordParameter", details.getPasswordParameter());
        beanMap.put("password", details.getAppUser().getRelatedPassword());
        beanMap.put("preSubmit", details.getPreSubmit());
        beanMap.put("submitType", details.getSubmitType());
        beanMap.put("submitKey", details.getSubmitKey());
        String jsonString = JsonUtils.object2Json(beanMap);
        _logger.debug("Token : " + jsonString);
        return jsonString;
    }

    public String encrypt(String data, String algorithmKey, String algorithm) {
        _logger.debug("Parameter String : " + data);
        String encoderParamString = HexUtils.bytes2HexString((byte[])data.getBytes());
        return encoderParamString;
    }

    public String sign(String data, Apps app) {
        String signData = super.sign(data, app);
        return signData;
    }

    public ModelAndView authorize(UserInfo userInfo, Object app, String data, ModelAndView modelAndView) {
        modelAndView.setViewName("authorize/desktop_sso_execute");
        AppsDesktopDetails details = (AppsDesktopDetails)app;
        modelAndView.addObject("username", (Object)details.getAppUser().getRelatedUsername());
        modelAndView.addObject("password", (Object)details.getAppUser().getRelatedPassword());
        modelAndView.addObject("encoderParam", (Object)data);
        return modelAndView;
    }
}

