/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.util.StringTokenizer;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mybatis.jpa.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementHandlerInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Dialect dialect;
    protected String dialectString;

    public void setDialect(Dialect dialect) {
        this.logger.debug("dialect from bean : {}", (Object)dialect);
        this.dialect = dialect;
    }

    public void setDialectString(String dialectString) {
        this.dialectString = dialectString;
        try {
            this.logger.debug("dialect from String : {}", (Object)dialectString);
            this.dialect = (Dialect)Class.forName(dialectString).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Dialect new error : ", (Throwable)e);
        }
    }

    protected StatementHandler getStatementHandler(Invocation invocation) {
        StatementHandler statement = (StatementHandler)invocation.getTarget();
        if (statement instanceof RoutingStatementHandler) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            return (StatementHandler)metaObject.getValue("delegate");
        }
        return statement;
    }

    protected RowBounds getRowBounds(StatementHandler statement) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
        return (RowBounds)metaObject.getValue("rowBounds");
    }

    protected boolean hasBounds(RowBounds rowBounds) {
        return rowBounds != null && rowBounds.getLimit() > 0 && rowBounds.getLimit() < Integer.MAX_VALUE;
    }

    protected String removeBreakingWhitespace(String original) {
        StringTokenizer whitespaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whitespaceStripper.hasMoreTokens()) {
            builder.append(whitespaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }
}

