/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.extractors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.utils.Preconditions;

public class JsonTokenExtractor
implements AccessTokenExtractor {
    private Pattern accessTokenPattern = Pattern.compile("\"access_token\":\\s*\"(\\S*?)\"");

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        Matcher matcher = this.accessTokenPattern.matcher(response);
        if (matcher.find()) {
            return new Token(matcher.group(1), "", response);
        }
        throw new OAuthException("Cannot extract an acces token. Response was: " + response);
    }
}

