/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.meta.FieldColumnMapper;
import org.dromara.mybatis.jpa.meta.FieldMetadata;
import org.dromara.mybatis.jpa.meta.TableMetadata;
import org.dromara.mybatis.jpa.provider.DateConverter;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(UpdateProvider.class);

    public String update(T entity) {
        FieldMetadata.buildColumnList(entity.getClass());
        List<FieldColumnMapper> listFields = FieldMetadata.getFieldsMap(entity.getClass());
        SQL sql = (SQL)new SQL().UPDATE(TableMetadata.getTableName(entity.getClass()));
        FieldColumnMapper partitionKey = null;
        FieldColumnMapper idFieldColumnMapper = null;
        for (FieldColumnMapper fieldColumnMapper : listFields) {
            logger.trace("Field {} , Type {}", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getFieldType());
            if (fieldColumnMapper.isIdColumn()) {
                idFieldColumnMapper = fieldColumnMapper;
                continue;
            }
            if (fieldColumnMapper.getPartitionKey() != null) {
                partitionKey = fieldColumnMapper;
                continue;
            }
            if (fieldColumnMapper.isLogicDelete()) continue;
            if ((fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || fieldColumnMapper.getFieldType().startsWith("byte") || BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == null) && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null && !fieldColumnMapper.isGenerated()) {
                logger.trace("skip {}({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getColumnName());
                continue;
            }
            if (!fieldColumnMapper.getColumnAnnotation().updatable()) continue;
            if (fieldColumnMapper.isGenerated() && fieldColumnMapper.getTemporalAnnotation() != null) {
                sql.SET(" %s =  '%s' ".formatted(fieldColumnMapper.getColumnName(), DateConverter.convert(entity, fieldColumnMapper, true)));
                continue;
            }
            sql.SET(" %s = #{%s} ".formatted(fieldColumnMapper.getColumnName(), fieldColumnMapper.getFieldName()));
        }
        if (idFieldColumnMapper != null) {
            if (partitionKey != null) {
                sql.WHERE("%s = #{%s}\nand %s = #{%s}\n".formatted(partitionKey.getColumnName(), partitionKey.getFieldName(), idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
            } else {
                sql.WHERE("%s = #{%s}".formatted(idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
            }
            logger.trace("Update SQL : \n{}", (Object)sql);
            return sql.toString();
        }
        return "";
    }

    public String updateByQuery(Class<?> entityClass, String setSql, Query query) {
        logger.trace("update By Query \n{}", (Object)query);
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(tableName)).SET(setSql)).WHERE(QueryBuilder.build(query));
        logger.trace("update By Query  SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String updateByLambdaQuery(Class<?> entityClass, String setSql, LambdaQuery<T> lambdaQuery) {
        logger.trace("update By LambdaQuery \n{}", lambdaQuery);
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        SQL sql = (SQL)((SQL)((SQL)new SQL().UPDATE(tableName)).SET(setSql)).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("update By LambdaQuery  SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

