/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.FieldMetadata;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(FindProvider.class);

    public String findAll(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        if (MapperMetadata.getSqlsMap().containsKey(tableName + "_FINDALL_SQL")) {
            return (String)MapperMetadata.getSqlsMap().get(tableName + "_FINDALL_SQL");
        }
        SQL sql = TableMetadata.buildSelect(entityClass);
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        String findAllSql = sql.toString();
        logger.trace("Find All SQL \n{}", (Object)findAllSql);
        MapperMetadata.getSqlsMap().put(tableName + "_FINDALL_SQL", findAllSql);
        return findAllSql;
    }

    public String find(Map<String, Object> parametersMap) throws Exception {
        Class entityClass = (Class)parametersMap.get("entityClass");
        Object[] args = (Object[])parametersMap.get("args");
        int[] argTypes = (int[])parametersMap.get("argTypes");
        String filterSql = parametersMap.get("filter").toString().trim();
        FieldMetadata.buildColumnList(entityClass);
        if (filterSql.toLowerCase().startsWith("where")) {
            filterSql = filterSql.substring(5);
        }
        if (args == null || args.length == 0) {
            filterSql = StrUtils.lineBreak2Blank(filterSql);
        } else {
            int countMatches = StringUtils.countMatches((CharSequence)filterSql, (CharSequence)"?");
            if (args.length < countMatches) {
                logger.error("args length {} < parameter placeholder {}", (Object)countMatches, (Object)args.length);
                throw new Exception("args length < parameter placeholder");
            }
            String[] filterSqls = filterSql.split("\\?");
            StringBuffer sqlBuffer = new StringBuffer("");
            int i = 0;
            while (i < filterSqls.length) {
                logger.trace("Find filterSqls[{}] = {}", (Object)i, (Object)filterSqls[i]);
                if (i < args.length) {
                    logger.trace("Find args[{}] {}", (Object)i, args[i]);
                    if (argTypes[i] == 12 || argTypes[i] == -9 || argTypes[i] == 1 || argTypes[i] == -15 || argTypes[i] == -1 || argTypes[i] == -16) {
                        sqlBuffer.append(filterSqls[i]).append("'").append(args[i].toString().replace("'", "")).append("'");
                    } else {
                        sqlBuffer.append(filterSqls[i]).append(args[i]);
                    }
                } else {
                    sqlBuffer.append(filterSqls[i]);
                }
                logger.trace("Find append {} time SQL [{}]", (Object)(i + 1), (Object)sqlBuffer);
                ++i;
            }
            filterSql = StrUtils.lineBreak2Blank(sqlBuffer.toString());
        }
        SQL sql = (SQL)TableMetadata.buildSelect(entityClass).WHERE("( " + filterSql + " )");
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        String findSql = sql.toString();
        logger.trace("Find SQL \n{}", (Object)findSql);
        return findSql;
    }

    public String findByIds(Map<String, Object> parametersMap) {
        Class parameterEntityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnList(parameterEntityClass);
        List parameterIds = (List)parametersMap.get("idList");
        StringBuffer keyValues = new StringBuffer();
        for (String value : parameterIds) {
            if (value.trim().length() <= 0) continue;
            keyValues.append(",'").append(value).append("'");
        }
        logger.trace("find by id {}", (Object)keyValues);
        String idsValues = keyValues.substring(1).replace(";", "");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(parameterEntityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(parameterEntityClass);
        SQL sql = TableMetadata.buildSelect(parameterEntityClass);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idsValues));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), idsValues));
        }
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(parameterEntityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = '%s'".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        String findByIdsSql = sql.toString();
        logger.trace("Find by ids SQL \n{}", (Object)findByIdsSql);
        return findByIdsSql;
    }
}

