/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jwt.encryption.service.impl;

import com.connsec.oidc.jose.keystore.JWKSetKeyStore;
import com.connsec.oidc.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import com.connsec.oidc.jwt.encryption.service.impl.DefaultJwtEncryptionAndDecryptionService;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class RecipientJwtEncryptionAndDecryptionServiceBuilder {
    static final Logger logger = Logger.getLogger(RecipientJwtEncryptionAndDecryptionServiceBuilder.class);
    private HttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
    private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
    private RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);

    public JwtEncryptionAndDecryptionService serviceBuilder(String jwksUri) {
        logger.debug((Object)("jwksUri : " + jwksUri));
        String jsonString = (String)this.restTemplate.getForObject(jwksUri, String.class, new Object[0]);
        logger.debug((Object)("jwks json String : " + jsonString));
        try {
            JWKSet jwkSet = JWKSet.parse((String)jsonString);
            JWKSetKeyStore keyStore = new JWKSetKeyStore(jwkSet);
            DefaultJwtEncryptionAndDecryptionService recipientJwtEncryptionAndDecryptionService = new DefaultJwtEncryptionAndDecryptionService(keyStore);
            return recipientJwtEncryptionAndDecryptionService;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (JOSEException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
}

