/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt;

import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWTClaimsSet
implements ReadOnlyJWTClaimsSet {
    private static final String TYPE_CLAIM = "typ";
    private static final String JWT_ID_CLAIM = "jti";
    private static final String ISSUED_AT_CLAIM = "iat";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String EXPIRATION_TIME_CLAIM = "exp";
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String SUBJECT_CLAIM = "sub";
    private static final String ISSUER_CLAIM = "iss";
    private static final Set<String> RESERVED_CLAIM_NAMES;
    private String iss = null;
    private String sub = null;
    private List<String> aud = null;
    private Date exp = null;
    private Date nbf = null;
    private Date iat = null;
    private String jti = null;
    private String typ = null;
    private Map<String, Object> customClaims = new HashMap<String, Object>();

    public JWTClaimsSet() {
    }

    public JWTClaimsSet(ReadOnlyJWTClaimsSet old) {
        this.setAllClaims(old.getAllClaims());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static Set<String> getReservedNames() {
        return RESERVED_CLAIM_NAMES;
    }

    @Override
    public String getIssuer() {
        return this.iss;
    }

    public void setIssuer(String iss) {
        this.iss = iss;
    }

    @Override
    public String getSubject() {
        return this.sub;
    }

    public void setSubject(String sub) {
        this.sub = sub;
    }

    @Override
    public List<String> getAudience() {
        return this.aud;
    }

    public void setAudience(List<String> aud) {
        this.aud = aud;
    }

    @Override
    public Date getExpirationTime() {
        return this.exp;
    }

    public void setExpirationTime(Date exp) {
        this.exp = exp;
    }

    @Override
    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public void setNotBeforeTime(Date nbf) {
        this.nbf = nbf;
    }

    @Override
    public Date getIssueTime() {
        return this.iat;
    }

    public void setIssueTime(Date iat) {
        this.iat = iat;
    }

    @Override
    public String getJWTID() {
        return this.jti;
    }

    public void setJWTID(String jti) {
        this.jti = jti;
    }

    @Override
    public String getType() {
        return this.typ;
    }

    public void setType(String typ) {
        this.typ = typ;
    }

    @Override
    public Object getCustomClaim(String name) {
        return this.customClaims.get(name);
    }

    public void setCustomClaim(String name, Object value) {
        if (JWTClaimsSet.getReservedNames().contains(name)) {
            throw new IllegalArgumentException("The claim name \"" + name + "\" matches a reserved name");
        }
        this.customClaims.put(name, value);
    }

    @Override
    public Map<String, Object> getCustomClaims() {
        return Collections.unmodifiableMap(this.customClaims);
    }

    public void setCustomClaims(Map<String, Object> customClaims) {
        if (customClaims == null) {
            return;
        }
        this.customClaims = customClaims;
    }

    @Override
    public Object getClaim(String name) {
        if (!JWTClaimsSet.getReservedNames().contains(name)) {
            return this.getCustomClaim(name);
        }
        if (ISSUER_CLAIM.equals(name)) {
            return this.getIssuer();
        }
        if (SUBJECT_CLAIM.equals(name)) {
            return this.getSubject();
        }
        if (AUDIENCE_CLAIM.equals(name)) {
            return this.getAudience();
        }
        if (EXPIRATION_TIME_CLAIM.equals(name)) {
            return this.getExpirationTime();
        }
        if (NOT_BEFORE_CLAIM.equals(name)) {
            return this.getNotBeforeTime();
        }
        if (ISSUED_AT_CLAIM.equals(name)) {
            return this.getIssueTime();
        }
        if (JWT_ID_CLAIM.equals(name)) {
            return this.getJWTID();
        }
        if (TYPE_CLAIM.equals(name)) {
            return this.getType();
        }
        throw new IllegalArgumentException("Couldn't find reserved claim: " + name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setClaim(String name, Object value) {
        if (!JWTClaimsSet.getReservedNames().contains(name)) {
            this.setCustomClaim(name, value);
            return;
        } else if (ISSUER_CLAIM.equals(name)) {
            if (!(value instanceof String)) throw new IllegalArgumentException("Issuer claim must be a String");
            this.setIssuer((String)value);
            return;
        } else if (SUBJECT_CLAIM.equals(name)) {
            if (!(value instanceof String)) throw new IllegalArgumentException("Subject claim must be a String");
            this.setSubject((String)value);
            return;
        } else if (AUDIENCE_CLAIM.equals(name)) {
            if (!(value instanceof List)) throw new IllegalArgumentException("Audience claim must be a List<String>");
            this.setAudience((List)value);
            return;
        } else if (EXPIRATION_TIME_CLAIM.equals(name)) {
            if (!(value instanceof Date)) throw new IllegalArgumentException("Expiration claim must be a Date");
            this.setExpirationTime((Date)value);
            return;
        } else if (NOT_BEFORE_CLAIM.equals(name)) {
            if (!(value instanceof Date)) throw new IllegalArgumentException("Not-before claim must be a Date");
            this.setNotBeforeTime((Date)value);
            return;
        } else if (ISSUED_AT_CLAIM.equals(name)) {
            if (!(value instanceof Date)) throw new IllegalArgumentException("Issued-at claim must be a Date");
            this.setIssueTime((Date)value);
            return;
        } else if (JWT_ID_CLAIM.equals(name)) {
            if (!(value instanceof String)) throw new IllegalArgumentException("JWT-ID claim must be a String");
            this.setJWTID((String)value);
            return;
        } else {
            if (!TYPE_CLAIM.equals(name)) throw new IllegalArgumentException("Couldn't find reserved claim: " + name);
            if (!(value instanceof String)) throw new IllegalArgumentException("Type claim must be a String");
            this.setType((String)value);
        }
    }

    @Override
    public Map<String, Object> getAllClaims() {
        HashMap<String, Object> allClaims = new HashMap<String, Object>();
        allClaims.putAll(this.customClaims);
        for (String reservedClaim : RESERVED_CLAIM_NAMES) {
            allClaims.put(reservedClaim, this.getClaim(reservedClaim));
        }
        return Collections.unmodifiableMap(allClaims);
    }

    public void setAllClaims(Map<String, Object> newClaims) {
        for (String name : newClaims.keySet()) {
            this.setClaim(name, newClaims.get(name));
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject(this.customClaims);
        if (this.iss != null) {
            o.put(ISSUER_CLAIM, this.iss);
        }
        if (this.sub != null) {
            o.put(SUBJECT_CLAIM, this.sub);
        }
        if (this.aud != null) {
            JSONArray audArray = new JSONArray();
            audArray.addAll(this.aud);
            o.put(AUDIENCE_CLAIM, audArray);
        }
        if (this.exp != null) {
            o.put(EXPIRATION_TIME_CLAIM, this.exp.getTime());
        }
        if (this.nbf != null) {
            o.put(NOT_BEFORE_CLAIM, this.nbf.getTime());
        }
        if (this.iat != null) {
            o.put(ISSUED_AT_CLAIM, this.iat.getTime());
        }
        if (this.jti != null) {
            o.put(JWT_ID_CLAIM, this.jti);
        }
        if (this.typ != null) {
            o.put(TYPE_CLAIM, this.typ);
        }
        return o;
    }

    public static JWTClaimsSet parse(JSONObject json) throws ParseException {
        JWTClaimsSet cs = new JWTClaimsSet();
        for (String name : json.keySet()) {
            if (name.equals(ISSUER_CLAIM)) {
                cs.setIssuer(JSONObjectUtils.getString(json, ISSUER_CLAIM));
                continue;
            }
            if (name.equals(SUBJECT_CLAIM)) {
                cs.setSubject(JSONObjectUtils.getString(json, SUBJECT_CLAIM));
                continue;
            }
            if (name.equals(AUDIENCE_CLAIM)) {
                Object audValue = json.get(AUDIENCE_CLAIM);
                if (audValue != null && audValue instanceof String) {
                    ArrayList<String> singleAud = new ArrayList<String>();
                    singleAud.add(JSONObjectUtils.getString(json, AUDIENCE_CLAIM));
                    cs.setAudience(singleAud);
                    continue;
                }
                cs.setAudience(JSONObjectUtils.getStringList(json, AUDIENCE_CLAIM));
                continue;
            }
            if (name.equals(EXPIRATION_TIME_CLAIM)) {
                cs.setExpirationTime(new Date(JSONObjectUtils.getLong(json, EXPIRATION_TIME_CLAIM)));
                continue;
            }
            if (name.equals(NOT_BEFORE_CLAIM)) {
                cs.setNotBeforeTime(new Date(JSONObjectUtils.getLong(json, NOT_BEFORE_CLAIM)));
                continue;
            }
            if (name.equals(ISSUED_AT_CLAIM)) {
                cs.setIssueTime(new Date(JSONObjectUtils.getLong(json, ISSUED_AT_CLAIM)));
                continue;
            }
            if (name.equals(JWT_ID_CLAIM)) {
                cs.setJWTID(JSONObjectUtils.getString(json, JWT_ID_CLAIM));
                continue;
            }
            if (name.equals(TYPE_CLAIM)) {
                cs.setType(JSONObjectUtils.getString(json, TYPE_CLAIM));
                continue;
            }
            cs.setCustomClaim(name, json.get(name));
        }
        return cs;
    }

    public String toString() {
        return "JWTClaimsSet [iss=" + this.iss + ", sub=" + this.sub + ", aud=" + this.aud + ", exp=" + this.exp + ", nbf=" + this.nbf + ", iat=" + this.iat + ", jti=" + this.jti + ", typ=" + this.typ + ", customClaims=" + this.customClaims + "]";
    }

    static {
        HashSet<String> n = new HashSet<String>();
        n.add(ISSUER_CLAIM);
        n.add(SUBJECT_CLAIM);
        n.add(AUDIENCE_CLAIM);
        n.add(EXPIRATION_TIME_CLAIM);
        n.add(NOT_BEFORE_CLAIM);
        n.add(ISSUED_AT_CLAIM);
        n.add(JWT_ID_CLAIM);
        n.add(TYPE_CLAIM);
        RESERVED_CLAIM_NAMES = Collections.unmodifiableSet(n);
    }
}

