/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.Collection;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.ConditionValue;
import org.dromara.mybatis.jpa.query.Operator;
import org.dromara.mybatis.jpa.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(QueryBuilder.class);

    public static String build(Query query) {
        StringBuffer conditionString = new StringBuffer("");
        for (Condition condition : query.getConditions()) {
            condition.setColumn(condition.getColumn().replace("'", "").replace(" ", "").replace(";", ""));
            if (condition.getExpression().equals((Object)Operator.and) || condition.getExpression().equals((Object)Operator.or)) {
                conditionString.append(" ").append(condition.getExpression().getOperator()).append(" ");
                Object object = condition.getValue();
                if (!(object instanceof Query)) continue;
                Query subQuery = (Query)object;
                conditionString.append(" ( ").append(QueryBuilder.build(subQuery)).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.like) || condition.getExpression().equals((Object)Operator.notLike)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.ignoreCase)) {
                conditionString.append("UPPER(").append(condition.getColumn()).append(") ").append(Operator.eq.getOperator()).append(" ");
                conditionString.append("UPPER(").append(ConditionValue.valueOf(condition.getValue())).append(")");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeLeft)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeRight)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.eq) || condition.getExpression().equals((Object)Operator.notEq) || condition.getExpression().equals((Object)Operator.gt) || condition.getExpression().equals((Object)Operator.ge) || condition.getExpression().equals((Object)Operator.lt) || condition.getExpression().equals((Object)Operator.le)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.between) || condition.getExpression().equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                conditionString.append(" and ");
                conditionString.append(ConditionValue.valueOf(condition.getValue2())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.isNull) || condition.getExpression().equals((Object)Operator.isNotNull)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.in) || condition.getExpression().equals((Object)Operator.notIn)) {
                if (!condition.getValue().getClass().isArray()) continue;
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                conditionString.append(" ( ");
                Object[] objects = (Object[])condition.getValue();
                Object object = objects[0];
                if (object instanceof Collection) {
                    Collection cObjects = (Collection)object;
                    logger.debug("objects[0] is Collection {}", (Object)cObjects);
                    conditionString.append(QueryBuilder.buildCollection(cObjects));
                } else if (objects[0].getClass().isArray()) {
                    objects = (Object[])objects[0];
                    logger.debug("objects[0] is isArray {}", objects);
                    conditionString.append(QueryBuilder.buildArray(objects));
                } else {
                    logger.debug("not  isArray {}", objects);
                    conditionString.append(QueryBuilder.buildArray(objects));
                }
                conditionString.append(" ) ");
                continue;
            }
            if (!condition.getExpression().equals((Object)Operator.condition)) continue;
            conditionString.append(condition.getColumn().replace(";", ""));
        }
        return conditionString.toString();
    }

    private static String buildArray(Object[] objects) {
        StringBuffer conditionArray = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            if (conditionArray.length() > 0) {
                conditionArray.append(" , ");
            }
            conditionArray.append(ConditionValue.valueOf(objects[i]));
        }
        return conditionArray.toString();
    }

    private static String buildCollection(Collection<?> cObjects) {
        StringBuffer conditionArray = new StringBuffer();
        for (Object element : cObjects) {
            if (conditionArray.length() > 0) {
                conditionArray.append(" , ");
            }
            conditionArray.append(ConditionValue.valueOf(element));
            logger.debug("{}", element);
        }
        return conditionArray.toString();
    }

    public static String buildGroupBy(Query query) {
        StringBuffer groupBy = new StringBuffer();
        for (Condition condition : query.getGroupBy()) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(condition.getColumn());
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(Query query) {
        StringBuffer orderBy = new StringBuffer();
        for (Condition condition : query.getOrderBy()) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(condition.getColumn()).append(" ").append(condition.getValue());
        }
        return orderBy.toString();
    }
}

