/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.extractors;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.extractors.RequestTokenExtractor;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class TokenExtractorImpl
implements RequestTokenExtractor,
AccessTokenExtractor {
    private static final Pattern TOKEN_REGEX = Pattern.compile("oauth_token=([^&]+)");
    private static final Pattern SECRET_REGEX = Pattern.compile("oauth_token_secret=([^&]*)");

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extract(response, TOKEN_REGEX);
        String secret = this.extract(response, SECRET_REGEX);
        return new Token(token, secret, response);
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            try {
                return HttpEncoder.decode(matcher.group(1));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }
}

