/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.Operator;
import org.dromara.mybatis.jpa.query.Query;

public class QueryBuilder {
    public static String build(Query query) {
        StringBuffer conditionString = new StringBuffer("");
        for (Condition condition : query.getConditions()) {
            condition.setColumn(condition.getColumn().replaceAll("'", "").replaceAll(" ", "").replace(";", ""));
            if (condition.getExpression().equals((Object)Operator.and) || condition.getExpression().equals((Object)Operator.or)) {
                conditionString.append(" ").append(condition.getExpression().getOperator()).append(" ");
                if (condition.getValue() == null || !(condition.getValue() instanceof Query)) continue;
                conditionString.append(" ( ").append(QueryBuilder.build((Query)condition.getValue())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.like) || condition.getExpression().equals((Object)Operator.notLike)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeLeft)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeRight)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.eq) || condition.getExpression().equals((Object)Operator.notEq) || condition.getExpression().equals((Object)Operator.gt) || condition.getExpression().equals((Object)Operator.ge) || condition.getExpression().equals((Object)Operator.lt) || condition.getExpression().equals((Object)Operator.le)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(QueryBuilder.getConditionValue(condition.getValue()));
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.between) || condition.getExpression().equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(QueryBuilder.getConditionValue(condition.getValue()));
                conditionString.append(" and ");
                conditionString.append(QueryBuilder.getConditionValue(condition.getValue2())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.isNull) || condition.getExpression().equals((Object)Operator.isNotNull)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.in) || condition.getExpression().equals((Object)Operator.notIn)) {
                Object[] objects;
                if (!condition.getValue().getClass().isArray()) continue;
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                conditionString.append(" ( ");
                StringBuffer conditionArray = new StringBuffer();
                Object[] objectArray = objects = (Object[])condition.getValue();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (conditionArray.length() > 0) {
                        conditionArray.append(" , ");
                    }
                    conditionArray.append(QueryBuilder.getConditionValue(object));
                    ++n2;
                }
                conditionString.append(conditionArray);
                conditionString.append(" ) ");
                continue;
            }
            if (!condition.getExpression().equals((Object)Operator.condition)) continue;
            conditionString.append(condition.getColumn().replace(";", ""));
        }
        return conditionString.toString();
    }

    public static String buildGroupBy(Query query) {
        StringBuffer groupBy = new StringBuffer();
        for (Condition condition : query.getGroupBy()) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(condition.getColumn());
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(Query query) {
        StringBuffer orderBy = new StringBuffer();
        for (Condition condition : query.getGroupBy()) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(condition.getColumn()).append(" ").append(condition.getValue());
        }
        return orderBy.toString();
    }

    private static String getConditionValue(Object value) {
        StringBuffer conditionString = new StringBuffer("");
        String valueType = value.getClass().getSimpleName().toLowerCase();
        if (valueType.equals("string") || valueType.equals("char")) {
            conditionString.append("'").append(String.valueOf(value).replaceAll("'", "")).append("'");
        } else if (valueType.equals("int") || valueType.equals("long") || valueType.equals("integer") || valueType.equals("float") || valueType.equals("double")) {
            conditionString.append("").append(value).append("");
        } else {
            conditionString.append("'").append(String.valueOf(value).replaceAll("'", "")).append("'");
        }
        return conditionString.toString();
    }
}

