/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(GetProvider.class);

    public String get(Map<String, Object> parametersMap) {
        FieldColumnMapper logicColumnMapper;
        Class entityClass = (Class)parametersMap.get("entityClass");
        MapperMetadata.buildColumnList(entityClass);
        String tableName = MapperMetadata.getTableName(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(tableName) + "_GET_SQL")) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(tableName) + "_GET_SQL");
        }
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = MapperMetadata.getPartitionKey(entityClass.getSimpleName());
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = MapperMetadata.buildSelect(entityClass);
        sql.WHERE(" %s = #{%s}".formatted(idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} ".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue));
        }
        if ((logicColumnMapper = MapperMetadata.getLogicColumn(entityClass.getSimpleName())) != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" %s = %s".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getColumnLogic().value()));
        }
        String getSql = sql.toString();
        MapperMetadata.sqlsMap.put(String.valueOf(tableName) + "_GET_SQL", getSql);
        logger.trace("Get SQL \n{}", (Object)getSql);
        return getSql;
    }
}

