/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.SecretKey;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;

public class BasicX509Credential
extends BasicCredential
implements X509Credential {
    private X509Certificate entityCert;
    private Collection<X509Certificate> entityCertChain;
    private Collection<X509CRL> crls;

    @Override
    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    @Override
    public Collection<X509CRL> getCRLs() {
        return this.crls;
    }

    public void setCRLs(Collection<X509CRL> newCRLs) {
        this.crls = newCRLs;
    }

    @Override
    public X509Certificate getEntityCertificate() {
        return this.entityCert;
    }

    public void setEntityCertificate(X509Certificate cert) {
        this.entityCert = cert;
        if (cert != null) {
            this.setPublicKey(cert.getPublicKey());
        } else {
            this.setPublicKey(null);
        }
    }

    @Override
    public Collection<X509Certificate> getEntityCertificateChain() {
        if (this.entityCertChain == null && this.entityCert != null) {
            HashSet<X509Certificate> constructedChain = new HashSet<X509Certificate>(5);
            constructedChain.add(this.entityCert);
            return constructedChain;
        }
        return this.entityCertChain;
    }

    public void setEntityCertificateChain(Collection<X509Certificate> certs) {
        this.entityCertChain = new ArrayList<X509Certificate>(certs);
    }

    @Override
    public void setPublicKey(PublicKey key) {
        if (this.entityCert != null && !this.entityCert.getPublicKey().equals(key)) {
            throw new IllegalArgumentException("X509Credential already contains a certificate with a different public key");
        }
        super.setPublicKey(key);
    }

    @Override
    public void setSecretKey(SecretKey key) {
        if (key != null) {
            throw new UnsupportedOperationException("Secret (symmetric) key may not be set on an X509Credential instance");
        }
    }

    @Override
    public SecretKey getSecretKey() {
        return null;
    }
}

