/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class KBcircle
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint center;
    public double radius;

    public KBcircle(double x, double y, double r) {
        this(new KBpoint(x, y), r);
    }

    public KBcircle(KBpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public KBcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KBcircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        KBtokenizer t = new KBtokenizer(KBtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new KBpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBcircle) {
            KBcircle p = (KBcircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBcircle newKBcircle = (KBcircle)super.clone();
        if (newKBcircle.center != null) {
            newKBcircle.center = (KBpoint)newKBcircle.center.clone();
        }
        return newKBcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

