/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.mybatis.jpa.dialect.Dialect;
import org.dromara.mybatis.jpa.interceptor.StatementHandlerInterceptor;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisJpaSessionFactoryBean
extends SqlSessionFactoryBean {
    protected static Logger logger = LoggerFactory.getLogger(MyBatisJpaSessionFactoryBean.class);
    private List<Interceptor> interceptors = Collections.emptyList();
    private int timeout = 30;
    private String dialect = "mysql";

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory factory = super.buildSqlSessionFactory();
        Configuration config = factory.getConfiguration();
        logger.debug("buildSqlSessionFactory : {}", (Object)config);
        for (Interceptor interceptor : this.interceptors) {
            config.addInterceptor(interceptor);
        }
        StatementHandlerInterceptor statementHandlerInterceptor = new StatementHandlerInterceptor();
        statementHandlerInterceptor.setDialectString(Dialect.getDialect(this.dialect));
        config.addInterceptor((Interceptor)statementHandlerInterceptor);
        if (config.getDefaultStatementTimeout() == null || config.getDefaultStatementTimeout() == 0) {
            logger.debug("set StatementTimeout as default");
            config.setDefaultStatementTimeout(Integer.valueOf(this.timeout));
        }
        logger.debug("DefaultStatementTimeout : {}", (Object)config.getDefaultStatementTimeout());
        if (logger.isTraceEnabled()) {
            for (String mappedStatementName : config.getMappedStatementNames()) {
                logger.trace("MappedStatementName {} ", (Object)mappedStatementName);
            }
        }
        return factory;
    }

    public SqlSessionFactory build() throws Exception {
        return this.buildSqlSessionFactory();
    }
}

