/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.NoticeReference;

public class UserNotice {
    private static final int HASH_FACTOR = 31;
    private NoticeReference noticeRef;
    private String explicitText;

    public UserNotice() {
    }

    public UserNotice(NoticeReference ref) {
        this(ref, null);
    }

    public UserNotice(String text) {
        this(null, text);
    }

    public UserNotice(NoticeReference ref, String text) {
        this.noticeRef = ref;
        this.explicitText = text;
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public String getExplicitText() {
        return this.explicitText;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        if (this.explicitText != null) {
            ++count;
            sb.append(this.explicitText);
        }
        if (this.noticeRef != null) {
            if (++count > 1) {
                sb.append(", ");
            }
            sb.append("NoticeReference:");
            sb.append(this.noticeRef);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            result = false;
        } else {
            UserNotice other = (UserNotice)obj;
            result = (this.noticeRef != null ? this.noticeRef.equals(other.getNoticeRef()) : other.getNoticeRef() == null) && (this.explicitText != null ? this.noticeRef.equals(other.getNoticeRef()) : other.getNoticeRef() == null);
        }
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        if (this.noticeRef != null) {
            hash = 31 * hash + this.noticeRef.hashCode();
        }
        if (this.explicitText != null) {
            hash = 31 * hash + this.explicitText.hashCode();
        }
        return hash;
    }
}

