/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509;

import edu.vt.middleware.crypt.util.DERHelper;
import edu.vt.middleware.crypt.x509.types.RelativeDistinguishedName;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDNSequenceIterator
implements Iterator<RelativeDistinguishedName>,
Iterable<RelativeDistinguishedName> {
    private final ASN1Sequence sequence;
    private int position;

    public RDNSequenceIterator(byte[] encodedRDNSequence) {
        this(RDNSequenceIterator.toASN1Sequence(encodedRDNSequence));
    }

    public RDNSequenceIterator(ASN1Sequence rdnSequence) {
        this.sequence = rdnSequence;
        this.position = this.sequence.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.position > -1;
    }

    @Override
    public RelativeDistinguishedName next() {
        DEREncodable enc;
        if (!this.hasNext()) {
            throw new NoSuchElementException("Reached end of iterator.");
        }
        if (!((enc = this.sequence.getObjectAt(this.position--)) instanceof ASN1Set)) {
            throw new IllegalStateException("Next item is not an ASN.1 set.");
        }
        return RelativeDistinguishedName.fromASN1Set((ASN1Set)enc);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public Iterator<RelativeDistinguishedName> iterator() {
        return this;
    }

    private static ASN1Sequence toASN1Sequence(byte[] data) {
        DERObject obj;
        try {
            obj = DERHelper.toDERObject(data, false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error creating ASN.1 sequence from encoded bytes.", e);
        }
        if (obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        throw new IllegalArgumentException("Encoded data is not an ASN.1 sequence.");
    }
}

