/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.io.CredentialReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertificateCredentialReader
implements CredentialReader<X509Certificate> {
    private static final String CERTIFICATE_TYPE = "X.509";

    @Override
    public X509Certificate read(File file) throws IOException, CryptException {
        return this.read(new BufferedInputStream(new FileInputStream(file)));
    }

    @Override
    public X509Certificate read(InputStream in) throws IOException, CryptException {
        try {
            CertificateFactory cf = CryptProvider.getCertificateFactory(CERTIFICATE_TYPE);
            return (X509Certificate)cf.generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new CryptException("Failed reading X.509 certificate.", e);
        }
    }
}

