/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.io.CredentialReader;
import edu.vt.middleware.crypt.io.IOHelper;
import edu.vt.middleware.crypt.util.PemHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.DERObjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEncodedCredentialReader<T>
implements CredentialReader<T> {
    protected static final DERObjectIdentifier DSA_ID = new DERObjectIdentifier("1.2.840.10040.4.1");
    protected static final DERObjectIdentifier RSA_ID = new DERObjectIdentifier("1.2.840.113549.1.1.1");
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public T read(File file) throws IOException, CryptException {
        byte[] data = IOHelper.read(new FileInputStream(file).getChannel());
        if (PemHelper.isPem(data)) {
            data = PemHelper.decode(data);
        }
        return this.decode(data);
    }

    @Override
    public T read(InputStream in) throws IOException, CryptException {
        byte[] data = IOHelper.read(in);
        if (PemHelper.isPem(data)) {
            data = PemHelper.decode(data);
        }
        return this.decode(data);
    }

    protected abstract T decode(byte[] var1) throws CryptException;
}

