/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.AbstractCli;
import edu.vt.middleware.crypt.EncryptionAlgorithm;
import edu.vt.middleware.crypt.io.Base64FilterInputStream;
import edu.vt.middleware.crypt.io.Base64FilterOutputStream;
import edu.vt.middleware.crypt.io.HexFilterInputStream;
import edu.vt.middleware.crypt.io.HexFilterOutputStream;
import edu.vt.middleware.crypt.io.TeePrintStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public abstract class AbstractEncryptionCli
extends AbstractCli {
    protected static final String OPT_CIPHER = "cipher";
    protected static final String OPT_OUTFILE = "out";
    protected static final String OPT_ENCODING = "encoding";
    protected static final String OPT_ENCRYPT = "encrypt";
    protected static final String OPT_DECRYPT = "decrypt";
    protected static final String OPT_TAIL = "tail";

    protected void initOptions() {
        super.initOptions();
        Option cipher = new Option(OPT_CIPHER, true, "cipher algorithm");
        cipher.setArgName("algname");
        cipher.setOptionalArg(false);
        Option infile = new Option("in", true, "file to encrypt/decrypt; defaults to STDIN");
        infile.setArgName("filepath");
        infile.setOptionalArg(false);
        Option outfile = new Option(OPT_OUTFILE, true, "output file containing result; defaults to STDOUT");
        outfile.setArgName("filepath");
        outfile.setOptionalArg(false);
        Option encoding = new Option(OPT_ENCODING, true, "ciphertext encoding format, either base64 or hex");
        encoding.setArgName("format");
        encoding.setOptionalArg(false);
        this.options.addOption(cipher);
        this.options.addOption(infile);
        this.options.addOption(outfile);
        this.options.addOption(encoding);
        this.options.addOption(new Option(OPT_TAIL, "tail output from operation"));
    }

    protected void encrypt(EncryptionAlgorithm alg, InputStream in, OutputStream out) throws Exception {
        try {
            System.err.println("Beginning encryption.");
            alg.initEncrypt();
            alg.encrypt(in, out);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.closeStream(in);
            this.closeStream(out);
        }
        System.err.println("Encryption operation complete.");
    }

    protected void decrypt(EncryptionAlgorithm alg, InputStream in, OutputStream out) throws Exception {
        try {
            System.err.println("Beginning decryption.");
            alg.initDecrypt();
            alg.decrypt(in, out);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.closeStream(in);
            this.closeStream(out);
        }
        System.err.println("Decryption operation complete.");
    }

    protected InputStream getInputStream(CommandLine line) throws IOException {
        InputStream in = super.getInputStream(line);
        if (line.hasOption(OPT_DECRYPT) && line.hasOption(OPT_ENCODING)) {
            String encName = line.getOptionValue(OPT_ENCODING);
            if ("base64".equals(encName)) {
                in = new Base64FilterInputStream(in);
            } else if ("hex".equals(encName)) {
                in = new HexFilterInputStream(in);
            } else {
                throw new IllegalArgumentException("Unknown encoding.");
            }
        }
        return in;
    }

    protected OutputStream getOutputStream(CommandLine line) throws IOException {
        FilterOutputStream out = null;
        if (line.hasOption(OPT_OUTFILE)) {
            File file = new File(line.getOptionValue(OPT_OUTFILE));
            System.err.println("Writing output to " + file);
            out = line.hasOption(OPT_TAIL) ? new TeePrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), System.out) : new BufferedOutputStream(new FileOutputStream(file));
        } else {
            System.err.println("Writing output to STDOUT");
            out = System.out;
        }
        if (line.hasOption(OPT_ENCRYPT) && line.hasOption(OPT_ENCODING)) {
            String encName = line.getOptionValue(OPT_ENCODING);
            if ("base64".equals(encName)) {
                out = new Base64FilterOutputStream(out);
            } else if ("hex".equals(encName)) {
                out = new HexFilterOutputStream(out);
            } else {
                throw new IllegalArgumentException("Unknown encoding.");
            }
        }
        return out;
    }
}

