/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static int findBestCollectionSize(Iterable<?> iterable, int bestBet) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : bestBet;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> copyMapButFailOnNull(Map<? extends K, ? extends V> entries) {
        HashMap entriesToRemap = new HashMap(entries.size());
        entries.forEach((k, v) -> {
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            entriesToRemap.put(k, v);
        });
        return entriesToRemap;
    }

    public static <K, V> Map<K, V> map(K key0, V value0) {
        return Collections.singletonMap(key0, value0);
    }

    public static <K, V> Map<K, V> map(K key0, V value0, K key1, V value1) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(key0, value0);
        map.put(key1, value1);
        return map;
    }

    public static <K, V> Map<K, V> map(K key0, V value0, K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(key0, value0);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }
}

