/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.evaluator.AxisEvaluator;
import org.apache.tsik.xpath.evaluator.ContextImpl;
import org.apache.tsik.xpath.evaluator.NodeTestEvaluator;
import org.apache.tsik.xpath.evaluator.PredicateEvaluator;
import org.apache.tsik.xpath.evaluator.StepEvaluator;
import org.apache.tsik.xpath.util.NodeArray;
import org.apache.tsik.xpath.util.NodeSet;
import org.w3c.dom.Node;

public class RelativeStepEvaluator
extends StepEvaluator {
    private AxisEvaluator axis;
    private NodeTestEvaluator nodetest;
    private ArrayList predicates;

    public RelativeStepEvaluator(AxisEvaluator axis, NodeTestEvaluator nodetest) {
        this.axis = axis;
        this.nodetest = nodetest;
        this.predicates = new ArrayList();
    }

    public void addPredicate(PredicateEvaluator predicate) {
        this.predicates.add(predicate);
    }

    public NodeSet evaluate(Context _context, NodeSet input) {
        ContextImpl context = (ContextImpl)_context;
        Iterator i = input.iterator();
        NodeSet ns = new NodeSet();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            NodeArray na = this.axis.evaluate(node);
            this.nodetest.filter(context.invocation, na, this.axis.getPrincipalNodeType());
            if (!this.predicates.isEmpty()) {
                Iterator j = this.predicates.iterator();
                while (j.hasNext()) {
                    PredicateEvaluator predicate = (PredicateEvaluator)j.next();
                    predicate.filter(context.invocation, na, this.axis.isReverseAxis());
                }
            }
            ns.addAll(na);
        }
        return ns;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.axis.toString());
        sb.append("::");
        sb.append(this.nodetest.toString());
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
        }
        return sb.toString();
    }
}

