/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tsik.xpath.XPath;

class XPointer {
    XPointer() {
    }

    static boolean isBarenameXPointer(String val) {
        return val.indexOf(40) < 0;
    }

    static String formatXPointer(String expr, String[] namespaces) {
        StringBuffer buf = new StringBuffer(100);
        buf.append('#');
        for (int i = 0; i < namespaces.length; i += 2) {
            String prefix = namespaces[i];
            if (prefix == null || !XPointer.usesPrefix(expr, prefix)) continue;
            String uri = namespaces[i + 1];
            buf.append("xmlns(");
            buf.append(prefix);
            buf.append('=');
            XPointer.formatXPointerValue(buf, uri);
            buf.append(") ");
        }
        buf.append("xpointer(");
        XPointer.formatXPointerValue(buf, expr);
        buf.append(')');
        return buf.toString();
    }

    private static void formatXPointerValue(StringBuffer buf, String val) {
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c == '(' || c == ')' || c == '^') {
                buf.append('^');
            }
            buf.append(c);
        }
    }

    static XPath parseXPointer(String expr, Map namespaces) {
        int i;
        HashMap nsMap = new HashMap();
        if (namespaces != null) {
            Iterator i2 = namespaces.keySet().iterator();
            while (i2.hasNext()) {
                String prefix = (String)i2.next();
                if (prefix == null || !XPointer.usesPrefix(expr, prefix)) continue;
                nsMap.put(prefix, namespaces.get(prefix));
            }
        }
        StringBuffer buf = new StringBuffer(100);
        char[] chars = expr.toCharArray();
        if (chars[i = 0] == '#') {
            ++i;
        }
        while (i < chars.length) {
            int j;
            if (XPointer.atToken(chars, i = XPointer.parseLeadingWhitespace(chars, i), "xmlns(")) {
                j = XPointer.parseToChar(chars, i += 6, '=');
                if (j < 0) {
                    throw XPointer.newParseException("Symbol = missing in xmlns()", expr, i);
                }
                int k = XPointer.parseTrailingWhitespace(chars, j);
                String prefix = new String(chars, i, k - i);
                i = XPointer.parseLeadingWhitespace(chars, j + 1);
                if ((j = XPointer.parseToMatchingParen(chars, i, buf)) < 0) {
                    throw XPointer.newParseException("Balanced ) missing or invalid escape sequence in xmlns()", expr, i);
                }
                String uri = buf.toString();
                nsMap.put(prefix, uri);
                i = j + 1;
                continue;
            }
            if (XPointer.atToken(chars, i, "xpointer(")) {
                j = XPointer.parseToMatchingParen(chars, i += 9, buf);
                if (j < 0) {
                    throw XPointer.newParseException("Balanced ) missing or invalid escape sequence in xpointer()", expr, i);
                }
                return new XPath(buf.toString(), nsMap);
            }
            if ((i = XPointer.parseToChar(chars, i, '(')) < 0) {
                throw XPointer.newParseException("Missing ( in custom token", expr, i);
            }
            if ((j = XPointer.parseToMatchingParen(chars, ++i, buf)) < 0) {
                throw XPointer.newParseException("Balanced ) missing or invalid escape sequence in custom token", expr, i);
            }
            i = j + 1;
        }
        throw XPointer.newParseException("No xpointer() token found", expr, i);
    }

    private static RuntimeException newParseException(String msg, String expr, int offset) {
        throw new IllegalArgumentException(msg + ": XPointer parse error after offset " + offset + " in expression: " + expr);
    }

    private static boolean atToken(char[] chars, int i, String token) {
        int end = i + token.length();
        if (end > chars.length) {
            return false;
        }
        for (int j = i; j < end; ++j) {
            if (chars[j] == token.charAt(j - i)) continue;
            return false;
        }
        return true;
    }

    private static int parseLeadingWhitespace(char[] chars, int i) {
        while (i < chars.length && Character.isWhitespace(chars[i])) {
            ++i;
        }
        return i;
    }

    private static int parseTrailingWhitespace(char[] chars, int i) {
        while (i > 0 && i <= chars.length && Character.isWhitespace(chars[i - 1])) {
            --i;
        }
        return i;
    }

    private static int parseToChar(char[] chars, int i, char c) {
        while (i < chars.length) {
            if (c == chars[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseToMatchingParen(char[] chars, int i, StringBuffer buf) {
        buf.setLength(0);
        int nesting = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '^') {
                if (++i >= chars.length) {
                    return -1;
                }
                c = chars[i];
                if (c != '^' && c != '(' && c != ')') return -1;
                buf.append(c);
            } else if (c == '(') {
                ++nesting;
                buf.append(c);
            } else if (c == ')') {
                if (nesting <= 0) {
                    return i;
                }
                --nesting;
                buf.append(c);
            } else {
                buf.append(c);
            }
            ++i;
        }
        return -1;
    }

    private static boolean usesPrefix(String expr, String prefix) {
        int i = expr.indexOf(prefix);
        int j = i + prefix.length();
        return i > 0 && j < expr.length() && expr.charAt(j) == ':';
    }
}

