/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath;

import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tsik.xpath.BindingContext;
import org.apache.tsik.xpath.DefaultBindingContextImpl;
import org.apache.tsik.xpath.Expression;
import org.apache.tsik.xpath.ExpressionImpl;
import org.apache.tsik.xpath.XPathException;
import org.apache.tsik.xpath.XPathFactory;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.parser.XPathParser;

public class XPathFactoryImpl
implements XPathFactory {
    Map expressionCache = Collections.synchronizedMap(new WeakHashMap());
    BindingContext defbc = new DefaultBindingContextImpl();

    Expression parseExpression(String expression) throws XPathException {
        try {
            StringReader sr = new StringReader(expression + " ");
            XPathParser parser = new XPathParser(sr);
            ExprEvaluator ev = parser.ExprInput();
            ExpressionImpl exp = new ExpressionImpl(ev);
            return exp;
        }
        catch (Exception ex) {
            throw new XPathException(ex);
        }
    }

    public Expression getExpression(String expression) throws XPathException {
        Expression exp = (Expression)this.expressionCache.get(expression);
        if (exp == null) {
            exp = this.parseExpression(expression);
            this.expressionCache.put(expression, exp);
        }
        return exp;
    }

    public BindingContext getDefaultBindingContext() {
        return this.defbc;
    }
}

