/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.util.InternalRuntimeException;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class KeyInfo {
    private boolean immutable;
    private X509Certificate[] certs;
    private PublicKey keyValue;
    private byte[] ski;
    private String keyName;
    private String subjectName;
    private String issuerName;
    private String serialNumber;

    public PublicKey getKeyValue() {
        if (this.keyValue != null) {
            return this.keyValue;
        }
        if (this.certs != null) {
            return this.certs[0].getPublicKey();
        }
        return null;
    }

    public void setKeyValue(PublicKey keyValue) {
        if (this.immutable) {
            this.throwImmutable();
        }
        this.keyValue = keyValue;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certs;
    }

    public X509Certificate getCertificate() {
        return this.certs != null ? this.certs[0] : null;
    }

    public void setCertificate(X509Certificate cert) {
        if (this.immutable) {
            this.throwImmutable();
        }
        if (cert != null) {
            this.certs = new X509Certificate[]{cert};
            this.setCertificateInfo(cert);
        } else {
            this.certs = null;
        }
    }

    public void setCertificateChain(X509Certificate[] certChain) {
        if (this.immutable) {
            this.throwImmutable();
        }
        if (certChain != null && certChain.length > 0) {
            this.certs = certChain;
            this.setCertificateInfo(certChain[0]);
        } else {
            this.certs = null;
        }
    }

    public void setCertificateInfo(X509Certificate cert) {
        if (this.immutable) {
            this.throwImmutable();
        }
        this.setSubjectName(cert.getSubjectDN().getName());
        this.setIssuerSerial(cert.getIssuerDN().getName(), cert.getSerialNumber().toString());
    }

    public byte[] getKeyIdentifier() {
        if (this.ski == null && this.certs != null) {
            this.ski = KeyInfo.getSKIExtension(this.certs[0]);
        }
        return this.ski;
    }

    public void setKeyIdentifier(byte[] ski) {
        if (this.immutable) {
            this.throwImmutable();
        }
        this.ski = ski;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        if (this.immutable) {
            this.throwImmutable();
        }
        this.keyName = keyName;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        if (this.immutable) {
            this.throwImmutable();
        }
        this.subjectName = subjectName;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setIssuerSerial(String issuerName, String serialNumber) {
        if (this.immutable) {
            this.throwImmutable();
        }
        if (issuerName == null && serialNumber != null) {
            throw new IllegalArgumentException("issuerName is null");
        }
        this.issuerName = issuerName;
        this.serialNumber = serialNumber;
    }

    public boolean verifyTrust(TrustVerifier trustVerifier) throws TrustVerificationException {
        X509Certificate[] chain = this.getCertificateChain();
        if (chain != null && chain.length > 0) {
            trustVerifier.verifyTrust(chain);
            return true;
        }
        PublicKey key = this.getKeyValue();
        if (key != null) {
            trustVerifier.verifyTrust(key, this.getKeyName());
            return true;
        }
        return false;
    }

    public DOMWriteCursor toXML(DOMWriteCursor c, boolean insertBefore) {
        org.apache.tsik.xmlsig.elements.KeyInfo ki = new org.apache.tsik.xmlsig.elements.KeyInfo(this);
        return ki.toXml(c, insertBefore);
    }

    public static KeyInfo fromXML(DOMCursor c) {
        try {
            return org.apache.tsik.xmlsig.elements.KeyInfo.fromXml(c).getKeyInfo();
        }
        catch (ElementException e) {
            throw new InternalRuntimeException(e);
        }
    }

    public static byte[] getSKIExtension(X509Certificate cert) {
        byte[] ext = cert.getExtensionValue("2.5.29.14");
        if (ext != null) {
            byte[] ski = new byte[ext.length - 4];
            System.arraycopy(ext, 4, ski, 0, ski.length);
            return ski;
        }
        try {
            PublicKey key = cert.getPublicKey();
            if (key instanceof RSAPublicKey) {
                byte[] encoded = key.getEncoded();
                byte[] value = new byte[encoded.length - 22];
                System.arraycopy(encoded, 22, value, 0, value.length);
                MessageDigest md = MessageDigest.getInstance("SHA1");
                return md.digest(value);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return null;
    }

    private void throwImmutable() {
        throw new UnsupportedOperationException("KeyInfo is immutable");
    }
}

