/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.elements.EncryptedData;
import org.apache.tsik.xmlenc.elements.EncryptedKey;
import org.apache.tsik.xmlsig.KeyInfo;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;
import org.w3c.dom.Document;

public class Encryptor {
    private DOMCursor cursor;
    private Key encryptionKey;
    private AlgorithmType encryptionType;
    private Key keyEncryptionKey;
    private AlgorithmType keyEncryptionType;
    private KeyInfo keyInfo;
    private boolean encryptContent;
    private boolean useOldEncryption;
    private boolean useOldKeyEncryption;

    public Encryptor(Document doc, Key encryptionKey, AlgorithmType encryptionType) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(doc, encryptionKey, encryptionType, null, null, null);
    }

    public Encryptor(Document doc, Key encryptionKey, AlgorithmType encryptionType, KeyInfo keyInfo) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(doc, encryptionKey, encryptionType, null, null, keyInfo);
    }

    public Encryptor(Document doc, Key dataEncryptionKey, AlgorithmType dataEncryptionType, Key keyEncryptionKey, AlgorithmType keyEncryptionType) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(doc, dataEncryptionKey, dataEncryptionType, keyEncryptionKey, keyEncryptionType, null);
    }

    public Encryptor(Document doc, Key dataEncryptionKey, AlgorithmType dataEncryptionType, Key keyEncryptionKey, AlgorithmType keyEncryptionType, KeyInfo keyInfo) throws IllegalArgumentException, NoSuchAlgorithmException {
        this.cursor = new DOMWriteCursor(doc);
        this.encryptionKey = dataEncryptionKey;
        this.encryptionType = dataEncryptionType;
        this.keyEncryptionKey = keyEncryptionKey;
        this.keyEncryptionType = keyEncryptionType;
        this.keyInfo = keyInfo;
    }

    public void setContentEncryption(boolean encryptContent) {
        this.encryptContent = encryptContent;
    }

    public Document encrypt() throws IllegalArgumentException {
        try {
            return this.encrypt(new XPath("/"));
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Document encrypt(XPath xpath) throws IllegalArgumentException, XPathException {
        return this.encrypt(xpath, false);
    }

    public void encryptInPlace() throws IllegalArgumentException {
        try {
            this.encryptInPlace(new XPath("/"));
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void encryptInPlace(XPath xpath) throws IllegalArgumentException, XPathException {
        this.encrypt(xpath, true);
    }

    private Document encrypt(XPath xpath, boolean inPlace) throws IllegalArgumentException, XPathException {
        DOMWriteCursor wc;
        if (!this.cursor.moveToXPath(xpath)) {
            throw new XPathException("XPath expression '" + xpath.getXPath() + "'" + " evaluates to nothing");
        }
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.setCursor(this.cursor);
        encryptedData.setKey(this.encryptionKey);
        encryptedData.encrypt(this.encryptionType, this.encryptContent, this.useOldEncryption);
        if (this.keyEncryptionKey != null) {
            try {
                EncryptedKey encryptedKey = this.doEncryptKey(this.encryptionKey, this.keyEncryptionKey, this.keyEncryptionType, this.keyInfo);
                encryptedData.setEncryptedKey(encryptedKey);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e.toString());
            }
        } else if (this.keyInfo != null) {
            encryptedData.setKeyInfo(this.keyInfo);
        }
        if (inPlace) {
            wc = new DOMWriteCursor(this.cursor.getDocument());
        } else {
            wc = new DOMWriteCursor();
            this.cursor.moveToTop();
            wc.copyUnder(this.cursor);
        }
        wc.moveToXPath(xpath);
        DOMWriteCursor encDataCursor = new DOMWriteCursor();
        encryptedData.toXml(encDataCursor);
        if (this.encryptContent) {
            wc.clear();
            wc.copyUnder(encDataCursor);
        } else {
            DOMCursor testIfTop = wc.cloneCursor();
            testIfTop.moveToTop();
            if (wc.equals(testIfTop)) {
                wc.remove();
                wc.copyUnder(encDataCursor);
            } else {
                wc.copyBefore(encDataCursor);
                wc.remove();
            }
        }
        return wc.getDocument();
    }

    public Document encryptKey(Key keyToEncrypt, XPath xpath, boolean insertBefore) throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        return this.encryptKey(keyToEncrypt, xpath, insertBefore, false);
    }

    public void encryptKeyInPlace(Key keyToEncrypt, XPath xpath, boolean insertBefore) throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        this.encryptKey(keyToEncrypt, xpath, insertBefore, true);
    }

    private Document encryptKey(Key keyToEncrypt, XPath xpath, boolean insertBefore, boolean inPlace) throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        DOMWriteCursor wc;
        if (this.keyEncryptionKey != null) {
            throw new IllegalArgumentException("Cannot call encryptKey() when both data and key encryption keys were given to the constructor");
        }
        if (!this.cursor.moveToXPath(xpath)) {
            throw new XPathException("XPath expression '" + xpath.getXPath() + "'" + " evaluates to nothing");
        }
        EncryptedKey encryptedKey = this.doEncryptKey(keyToEncrypt, this.encryptionKey, this.encryptionType, this.keyInfo);
        if (inPlace) {
            wc = new DOMWriteCursor(this.cursor.getDocument());
        } else {
            wc = new DOMWriteCursor();
            this.cursor.moveToTop();
            wc.copyUnder(this.cursor);
        }
        wc.moveToXPath(xpath);
        DOMWriteCursor c = new DOMWriteCursor();
        encryptedKey.toXml(c);
        if (insertBefore) {
            wc.copyBefore(c);
        } else {
            wc.copyUnder(c);
        }
        return wc.getDocument();
    }

    private EncryptedKey doEncryptKey(Key keyToEncrypt, Key key, AlgorithmType type, KeyInfo info) throws NoSuchAlgorithmException {
        EncryptedKey encryptedKey = new EncryptedKey();
        encryptedKey.setKeyToEncrypt(keyToEncrypt);
        encryptedKey.setEncryptionKey(key);
        encryptedKey.encrypt(type, this.useOldKeyEncryption);
        if (info != null) {
            encryptedKey.setKeyInfo(info);
        }
        return encryptedKey;
    }

    public void useV1_4Encryption() {
        this.useOldEncryption = true;
    }

    public void useV1_7KeyEncryption() {
        this.useOldKeyEncryption = true;
    }
}

