/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class SimpleTrustVerifier
implements TrustVerifier {
    private Collection keys;

    public SimpleTrustVerifier(Collection keys) {
        this.keys = keys;
    }

    public void verifyTrust() throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        byte[] keyEncoded = key.getEncoded();
        Iterator i = this.keys.iterator();
        while (i.hasNext()) {
            PublicKey trusted = (PublicKey)i.next();
            if (!Arrays.equals(trusted.getEncoded(), keyEncoded)) continue;
            return;
        }
        throw new TrustVerificationException("key to check is not in the collection of trusted keys");
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        this.verifyTrust(key);
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        this.verifyTrust(chain[0].getPublicKey());
    }
}

