/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.apache.tsik.verifier.SSLContextAdapter;
import org.apache.tsik.verifier.SSLContextAdapterJDK14;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class SSLTrustAdapter {
    static final String NO_SSL_MESSAGE = "Neither JSSE nor JDK1.4 are present so SSL is not available";
    static boolean isJDK14Available = false;
    static boolean isJSSEAvailable = false;
    private static final Class[] NO_CLASSES;
    private SSLContextAdapter adapter;

    public static void verifySession(SSLSession session, TrustVerifier verifier) throws TrustVerificationException, SSLPeerUnverifiedException {
        X509Certificate[] chain = null;
        if (!isJDK14Available) {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
        chain = (X509Certificate[])session.getPeerCertificates();
        if (chain == null) {
            throw new TrustVerificationException();
        }
        verifier.verifyTrust(chain);
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode) throws GeneralSecurityException {
        this(verifier, verifierMode, (PrivateKey)null, null);
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        if (!isJDK14Available) {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
        this.adapter = new SSLContextAdapterJDK14(verifier, verifierMode, privateKey, certChain);
    }

    public SSLTrustAdapter(TrustVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        if (!isJDK14Available) {
            throw new RuntimeException(NO_SSL_MESSAGE);
        }
        this.adapter = new SSLContextAdapterJDK14(verifier, verifierMode, keyStore, password);
    }

    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.adapter.getSocketFactory();
    }

    public SSLServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return this.adapter.getServerSocketFactory();
    }

    public String toString() {
        return "[SSLTrustAdapter adapter=" + this.adapter + "]";
    }

    static {
        try {
            Class.forName("javax.net.ssl.HttpsURLConnection");
            isJDK14Available = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        NO_CLASSES = new Class[0];
    }
}

