/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBackedMetadataProvider
extends AbstractObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProvider.class);
    private Timer taskTimer;
    private long maxCacheDuration;
    private Resource metadataResource;
    private DateTime lastMetadataUpdate;
    private boolean maintainExpiredMetadata;
    private XMLObject cachedMetadata;

    public ResourceBackedMetadataProvider(Resource resource, Timer timer, long maxMetadataCacheDuration) throws MetadataProviderException {
        this.taskTimer = timer;
        if (maxMetadataCacheDuration < 1L) {
            throw new IllegalArgumentException("Max cache duration must be a positive number");
        }
        this.maxCacheDuration = maxMetadataCacheDuration;
        try {
            if (!resource.exists()) {
                throw new MetadataProviderException("Resource " + resource.getLocation() + " does not exist.");
            }
            this.metadataResource = resource;
            this.maintainExpiredMetadata = false;
        }
        catch (ResourceException e) {
            throw new MetadataProviderException("Unable to read resource", (Exception)((Object)e));
        }
    }

    public void initialize() throws MetadataProviderException {
        this.refreshMetadata();
    }

    public boolean maintainExpiredMetadata() {
        return this.maintainExpiredMetadata;
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.maintainExpiredMetadata = maintain;
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        return this.cachedMetadata;
    }

    private void refreshMetadata() throws MetadataProviderException {
        try {
            DateTime expirationTime;
            boolean metadataChanged = false;
            XMLObject metadata = this.getLatestMetadata();
            if (metadata != this.cachedMetadata) {
                metadataChanged = true;
            }
            if ((expirationTime = SAML2Helper.getEarliestExpiration(metadata)) != null && !this.maintainExpiredMetadata() && expirationTime.isBeforeNow()) {
                this.log.debug("Metadata from resource {} is expired and this provider is configured not to retain expired metadata.", (Object)this.metadataResource.getInputStream());
                this.cachedMetadata = null;
                metadataChanged = true;
            } else {
                this.cachedMetadata = metadata;
            }
            if (metadataChanged) {
                this.emitChangeEvent();
            }
            long nextUpdateDelay = 0L;
            if (expirationTime != null && expirationTime.isBefore(System.currentTimeMillis() + this.maxCacheDuration)) {
                nextUpdateDelay = expirationTime.getMillis() - System.currentTimeMillis();
            }
            if (nextUpdateDelay <= 0L) {
                nextUpdateDelay = this.maxCacheDuration;
            }
            this.log.debug("Next refresh of metadata from resource {} scheduled in {}ms", (Object)this.metadataResource.getLocation(), (Object)nextUpdateDelay);
            this.taskTimer.schedule((TimerTask)new MetadataPollTask(), nextUpdateDelay);
        }
        catch (ResourceException e) {
            String errorMsg = "Unable to read metadata file";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
    }

    private XMLObject getLatestMetadata() throws MetadataProviderException {
        try {
            XMLObject metadata;
            DateTime metadataUpdateTime = this.metadataResource.getLastModifiedTime();
            if (this.lastMetadataUpdate == null || metadataUpdateTime.isAfter((ReadableInstant)this.lastMetadataUpdate)) {
                this.lastMetadataUpdate = metadataUpdateTime;
                this.log.debug("Refreshing metadata from resource {}", (Object)this.metadataResource.getLocation());
                metadata = this.unmarshallMetadata(this.metadataResource.getInputStream());
                this.filterMetadata(metadata);
                this.releaseMetadataDOM(metadata);
            } else {
                metadata = this.cachedMetadata;
            }
            return metadata;
        }
        catch (ResourceException e) {
            String errorMsg = "Unable to read metadata file";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }

    private class MetadataPollTask
    extends TimerTask {
        private MetadataPollTask() {
        }

        public void run() {
            try {
                ResourceBackedMetadataProvider.this.log.debug("Checking if metadata from resource {} should be updated", (Object)ResourceBackedMetadataProvider.this.metadataResource.getLocation());
                ResourceBackedMetadataProvider.this.refreshMetadata();
            }
            catch (MetadataProviderException e) {
                ResourceBackedMetadataProvider.this.log.error("Unable to refresh metadata", (Throwable)e);
            }
        }
    }
}

