/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.builder.api;

import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.oauth.builder.api.Api;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.extractors.BaseStringExtractor;
import org.maxkey.client.oauth.extractors.BaseStringExtractorImpl;
import org.maxkey.client.oauth.extractors.HeaderExtractor;
import org.maxkey.client.oauth.extractors.HeaderExtractorImpl;
import org.maxkey.client.oauth.extractors.RequestTokenExtractor;
import org.maxkey.client.oauth.extractors.TokenExtractorImpl;
import org.maxkey.client.oauth.model.OAuthConfig;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.oauth.oauth.OAuth10aServiceImpl;
import org.maxkey.client.oauth.oauth.OAuthService;
import org.maxkey.client.oauth.services.HMACSha1SignatureService;
import org.maxkey.client.oauth.services.SignatureService;
import org.maxkey.client.oauth.services.TimestampService;
import org.maxkey.client.oauth.services.TimestampServiceImpl;

public abstract class DefaultApi10a
implements Api {
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    public HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    public RequestTokenExtractor getRequestTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    public TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    public HttpVerb getAccessTokenVerb() {
        return HttpVerb.POST;
    }

    public HttpVerb getRequestTokenVerb() {
        return HttpVerb.POST;
    }

    public abstract String getRequestTokenEndpoint();

    public abstract String getAccessTokenEndpoint();

    public abstract String getAuthorizationUrl(Token var1);

    @Override
    public OAuthService createService(OAuthConfig config) {
        return new OAuth10aServiceImpl(this, config);
    }
}

