/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption.validator;

import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.ReferenceType;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class ReferenceTypeSchemaValidator
implements Validator<ReferenceType> {
    @Override
    public void validate(ReferenceType xmlObject) throws ValidationException {
        this.validateURI(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
    }

    protected void validateURI(ReferenceType xmlObject) throws ValidationException {
        if (DatatypeHelper.isEmpty(xmlObject.getURI())) {
            throw new ValidationException("ReferenceType URI was empty");
        }
    }

    protected void validateChildrenNamespaces(ReferenceType xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getUnknownXMLObjects()) {
            QName childName = child.getElementQName();
            if (!"http://www.w3.org/2001/04/xmlenc#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("ReferenceType contains an illegal child extension element: " + childName);
        }
    }
}

