/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class TraceSqlIntercept
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(TraceSqlIntercept.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object proceed;
        block9: {
            long executeStartTime = System.currentTimeMillis();
            proceed = invocation.proceed();
            long executeFinishTime = System.currentTimeMillis();
            String printSql = null;
            try {
                try {
                    if (logger.isTraceEnabled()) {
                        printSql = TraceSqlIntercept.buildPrintSql(invocation);
                    }
                }
                catch (Exception exception) {
                    logger.error("Get SQL Exception", (Throwable)exception);
                    if (StringUtils.isNotBlank((CharSequence)printSql)) {
                        logger.trace("Execute SQL Cost Time {}ms , SQL :\n {}", (Object)(executeFinishTime - executeStartTime), (Object)printSql);
                        break block9;
                    }
                    logger.trace("Execute SQL Cost Time {}ms ", (Object)(executeFinishTime - executeStartTime));
                }
            }
            finally {
                if (StringUtils.isNotBlank(printSql)) {
                    logger.trace("Execute SQL Cost Time {}ms , SQL :\n {}", (Object)(executeFinishTime - executeStartTime), (Object)printSql);
                } else {
                    logger.trace("Execute SQL Cost Time {}ms ", (Object)(executeFinishTime - executeStartTime));
                }
            }
        }
        return proceed;
    }

    private static String buildPrintSql(Invocation invocation) {
        MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
        if (statement.getId().endsWith("fetchCount")) {
            return "";
        }
        Object args = null;
        if (invocation.getArgs().length > 1) {
            args = invocation.getArgs()[1];
        }
        Configuration configuration = statement.getConfiguration();
        BoundSql boundSql = statement.getBoundSql(args);
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String originalSql = boundSql.getSql();
        String sql = "";
        if (StringUtils.isNotBlank((CharSequence)originalSql) && originalSql.indexOf("?") > -1) {
            sql = originalSql;
            sql = sql.replaceAll("[\\s]+", " ");
            logger.trace("Args {}", args);
            logger.trace("Original SQL \n {}", (Object)sql);
            if (!ObjectUtils.isEmpty((Object)parameterMappings) && !ObjectUtils.isEmpty((Object)parameterObject)) {
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(TraceSqlIntercept.getParameterValue(parameterObject)));
                } else {
                    for (ParameterMapping parameterMapping : parameterMappings) {
                        Object obj;
                        String propertyName = parameterMapping.getProperty();
                        MetaObject metaObject = configuration.newMetaObject(parameterObject);
                        if (metaObject.hasGetter(propertyName)) {
                            obj = metaObject.getValue(propertyName);
                            sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(TraceSqlIntercept.getParameterValue(obj)));
                            continue;
                        }
                        if (boundSql.hasAdditionalParameter(propertyName)) {
                            obj = boundSql.getAdditionalParameter(propertyName);
                            sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(TraceSqlIntercept.getParameterValue(obj)));
                            continue;
                        }
                        sql = sql.replaceFirst("\\?", "Missing Parameter");
                    }
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object object) {
        Object value = "";
        if (object instanceof String) {
            value = "'" + object.toString() + "'";
        } else if (object instanceof Date) {
            Date dateValue = (Date)object;
            DateFormat format = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + format.format(dateValue) + "'";
        } else if (!ObjectUtils.isEmpty((Object)object)) {
            value = object.toString();
        }
        return value;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

