/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.lang.reflect.Method;
import java.sql.Connection;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.dromara.mybatis.jpa.interceptor.AbstractStatementHandlerInterceptor;
import org.dromara.mybatis.jpa.interceptor.builder.FindBySqlBuilder;
import org.dromara.mybatis.jpa.interceptor.builder.SelectPageSql;
import org.dromara.mybatis.jpa.interceptor.builder.SelectPageSqlBuilder;
import org.dromara.mybatis.jpa.metadata.findby.FindByMapper;
import org.dromara.mybatis.jpa.metadata.findby.FindByMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class StatementHandlerInterceptor
extends AbstractStatementHandlerInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(StatementHandlerInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        if ("prepare".equals(m.getName())) {
            return this.prepare(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    private Object prepare(Invocation invocation) throws Throwable {
        StatementHandler statement = this.getStatementHandler(invocation);
        if (statement instanceof SimpleStatementHandler || statement instanceof PreparedStatementHandler) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            BoundSql boundSql = statement.getBoundSql();
            Object parameterObject = metaObject.getValue("parameterHandler.parameterObject");
            MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("mappedStatement");
            if (FindBySqlBuilder.isFindBy(this.dialectString, boundSql)) {
                FindBySqlBuilder.parse(mappedStatement.getId(), boundSql);
                FindByMapper findByMapper = FindByMetadata.getFindByMapper(mappedStatement.getId());
                metaObject.setValue("boundSql.sql", (Object)FindBySqlBuilder.translate(findByMapper, parameterObject));
            } else {
                SelectPageSql selectPageSql = SelectPageSqlBuilder.parse(boundSql, parameterObject);
                logger.trace("parameter {}({})", parameterObject, (Object)(parameterObject == null ? "" : parameterObject.getClass().getCanonicalName()));
                if (selectPageSql.isSelectTrack() && selectPageSql.isPageable()) {
                    String selectSql = SelectPageSqlBuilder.translate(statement, this.dialect, boundSql, selectPageSql);
                    metaObject.setValue("boundSql.sql", (Object)selectSql);
                }
            }
        }
        return invocation.proceed();
    }
}

