/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.token.endpoint;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.maxkey.authz.endpoint.AuthorizeBaseEndpoint;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.authz.token.endpoint.adapter.TokenBasedDefaultAdapter;
import org.maxkey.config.ApplicationConfig;
import org.maxkey.constants.BOOLEAN;
import org.maxkey.dao.service.AppsTokenBasedDetailsService;
import org.maxkey.domain.apps.Apps;
import org.maxkey.domain.apps.AppsTokenBasedDetails;
import org.maxkey.util.Instance;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TokenBasedAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(TokenBasedAuthorizeEndpoint.class);
    @Autowired
    AppsTokenBasedDetailsService tokenBasedDetailsService;
    TokenBasedDefaultAdapter defaultTokenBasedAdapter = new TokenBasedDefaultAdapter();
    @Autowired
    ApplicationConfig applicationConfig;

    @RequestMapping(value={"/authz/tokenbased/{id}"})
    public ModelAndView authorize(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) {
        ModelAndView modelAndView = new ModelAndView();
        AppsTokenBasedDetails tokenBasedDetails = null;
        tokenBasedDetails = (AppsTokenBasedDetails)this.tokenBasedDetailsService.get(id);
        _logger.debug("" + tokenBasedDetails);
        Apps application = this.getApp(id);
        tokenBasedDetails.setAdapter(application.getAdapter());
        tokenBasedDetails.setIsAdapter(application.getIsAdapter());
        TokenBasedDefaultAdapter adapter = BOOLEAN.isTrue((int)tokenBasedDetails.getIsAdapter()) ? (AbstractAuthorizeAdapter)Instance.newInstance((String)tokenBasedDetails.getAdapter()) : this.defaultTokenBasedAdapter;
        String tokenData = adapter.generateInfo(WebContext.getUserInfo(), tokenBasedDetails);
        String encryptTokenData = adapter.encrypt(tokenData, tokenBasedDetails.getAlgorithmKey(), tokenBasedDetails.getAlgorithm());
        String signTokenData = adapter.sign(encryptTokenData, (Apps)tokenBasedDetails);
        if (tokenBasedDetails.getTokenType().equalsIgnoreCase("POST")) {
            modelAndView = adapter.authorize(WebContext.getUserInfo(), tokenBasedDetails, signTokenData, modelAndView);
            return modelAndView;
        }
        String cookieValue = "";
        cookieValue = signTokenData;
        _logger.debug("Cookie Name : " + tokenBasedDetails.getCookieName());
        Cookie cookie = new Cookie(tokenBasedDetails.getCookieName(), cookieValue);
        Integer maxAge = Integer.parseInt(tokenBasedDetails.getExpires()) * 60;
        _logger.debug("Cookie Max Age :" + maxAge + " seconds.");
        cookie.setMaxAge(maxAge.intValue());
        cookie.setPath("/");
        cookie.setDomain(this.applicationConfig.getSubDomainName());
        _logger.debug("Sub Domain Name : ." + this.applicationConfig.getSubDomainName());
        response.addCookie(cookie);
        if (tokenBasedDetails.getRedirectUri().indexOf(this.applicationConfig.getSubDomainName()) > -1) {
            return WebContext.redirect((String)tokenBasedDetails.getRedirectUri());
        }
        _logger.error(tokenBasedDetails.getRedirectUri() + " not in domain " + this.applicationConfig.getSubDomainName());
        return null;
    }
}

