/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.ecp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.impl.AbstractSAMLObject;
import org.opensaml.saml2.core.IDPList;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.ecp.Request;
import org.opensaml.ws.soap.soap11.ActorBearing;
import org.opensaml.ws.soap.soap11.MustUnderstandBearing;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSBooleanValue;

public class RequestImpl
extends AbstractSAMLObject
implements Request {
    private IDPList idpList;
    private Issuer issuer;
    private String providerName;
    private XSBooleanValue isPassive;
    private String soap11Actor;
    private XSBooleanValue soap11MustUnderstand;

    protected RequestImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public IDPList getIDPList() {
        return this.idpList;
    }

    @Override
    public void setIDPList(IDPList newIDPList) {
        this.idpList = (IDPList)this.prepareForAssignment((XMLObject)this.idpList, (XMLObject)newIDPList);
    }

    @Override
    public Issuer getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(Issuer newIssuer) {
        this.issuer = (Issuer)this.prepareForAssignment((XMLObject)this.issuer, (XMLObject)newIssuer);
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void setProviderName(String newProviderName) {
        this.providerName = this.prepareForAssignment(this.providerName, newProviderName);
    }

    @Override
    public Boolean isPassive() {
        if (this.isPassive != null) {
            return this.isPassive.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isPassiveXSBoolean() {
        return this.isPassive;
    }

    @Override
    public void setPassive(Boolean newIsPassive) {
        this.isPassive = newIsPassive != null ? (XSBooleanValue)this.prepareForAssignment(this.isPassive, new XSBooleanValue(newIsPassive, false)) : (XSBooleanValue)this.prepareForAssignment(this.isPassive, null);
    }

    @Override
    public void setPassive(XSBooleanValue newIsPassive) {
        this.isPassive = (XSBooleanValue)this.prepareForAssignment(this.isPassive, newIsPassive);
    }

    public Boolean isSOAP11MustUnderstand() {
        if (this.soap11MustUnderstand != null) {
            return this.soap11MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    public XSBooleanValue isSOAP11MustUnderstandXSBoolean() {
        return this.soap11MustUnderstand;
    }

    public void setSOAP11MustUnderstand(Boolean newMustUnderstand) {
        this.soap11MustUnderstand = newMustUnderstand != null ? (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, new XSBooleanValue(newMustUnderstand, true)) : (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, null);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    public void setSOAP11MustUnderstand(XSBooleanValue newMustUnderstand) {
        this.soap11MustUnderstand = (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, newMustUnderstand);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    public String getSOAP11Actor() {
        return this.soap11Actor;
    }

    public void setSOAP11Actor(String newActor) {
        this.soap11Actor = this.prepareForAssignment(this.soap11Actor, newActor);
        this.manageQualifiedAttributeNamespace(ActorBearing.SOAP11_ACTOR_ATTR_NAME, this.soap11Actor != null);
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<SAMLObject> children = new ArrayList<SAMLObject>();
        if (this.issuer != null) {
            children.add(this.issuer);
        }
        if (this.idpList != null) {
            children.add(this.idpList);
        }
        return Collections.unmodifiableList(children);
    }
}

