/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.util.storage.ExpiringObject;

public abstract class AbstractExpiringObject
implements ExpiringObject,
Serializable {
    private long expiration;

    public AbstractExpiringObject(DateTime expirationTime) {
        this.expiration = expirationTime.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
    }

    @Override
    public DateTime getExpirationTime() {
        return new DateTime(this.expiration, (Chronology)ISOChronology.getInstanceUTC());
    }

    @Override
    public boolean isExpired() {
        return this.getExpirationTime().isBeforeNow();
    }

    @Override
    public void onExpire() {
    }
}

