/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.List;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.ConditionValue;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Operator;

public class LambdaQueryBuilder {
    public static String build(LambdaQuery lambdaQuery) {
        StringBuffer conditionString = new StringBuffer("");
        List<Condition> conditions = lambdaQuery.getConditions();
        for (Condition condition : conditions) {
            condition.setColumn(condition.getColumn().replace("'", "").replace(" ", "").replace(";", ""));
            if (condition.getExpression().equals((Object)Operator.and) || condition.getExpression().equals((Object)Operator.or)) {
                conditionString.append(" ").append(condition.getExpression().getOperator()).append(" ");
                Object object = condition.getValue();
                if (!(object instanceof LambdaQuery)) continue;
                LambdaQuery lambdaQueryValue = (LambdaQuery)object;
                conditionString.append(" ( ").append(LambdaQueryBuilder.build(lambdaQueryValue)).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.like) || condition.getExpression().equals((Object)Operator.notLike)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeLeft)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeRight)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.eq) || condition.getExpression().equals((Object)Operator.notEq) || condition.getExpression().equals((Object)Operator.gt) || condition.getExpression().equals((Object)Operator.ge) || condition.getExpression().equals((Object)Operator.lt) || condition.getExpression().equals((Object)Operator.le)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.between) || condition.getExpression().equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                conditionString.append(" and ");
                conditionString.append(ConditionValue.valueOf(condition.getValue2())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.isNull) || condition.getExpression().equals((Object)Operator.isNotNull)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.in) || condition.getExpression().equals((Object)Operator.notIn)) {
                Object[] objects;
                if (!condition.getValue().getClass().isArray()) continue;
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                conditionString.append(" ( ");
                StringBuffer conditionArray = new StringBuffer();
                for (Object object : objects = (Object[])condition.getValue()) {
                    if (conditionArray.length() > 0) {
                        conditionArray.append(" , ");
                    }
                    conditionArray.append(ConditionValue.valueOf(object));
                }
                conditionString.append(conditionArray);
                conditionString.append(" ) ");
                continue;
            }
            if (!condition.getExpression().equals((Object)Operator.condition)) continue;
            conditionString.append(condition.getColumn().replace(";", ""));
        }
        return conditionString.toString();
    }

    public static String buildGroupBy(LambdaQuery lambdaQuery) {
        StringBuffer groupBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(condition.getColumn());
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(LambdaQuery lambdaQuery) {
        StringBuffer orderBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(condition.getColumn()).append(" ").append(condition.getValue());
        }
        return orderBy.toString();
    }
}

