/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.dromara.mybatis.jpa.meta.FieldColumnMapper;
import org.dromara.mybatis.jpa.meta.FieldMetadata;
import org.dromara.mybatis.jpa.meta.TableMetadata;
import org.dromara.mybatis.jpa.provider.DateConverter;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(InsertProvider.class);

    public String insert(T entity) {
        FieldMetadata.buildColumnList(entity.getClass());
        List<FieldColumnMapper> listFields = FieldMetadata.getFieldsMap(entity.getClass());
        SQL sql = (SQL)new SQL().INSERT_INTO(TableMetadata.getTableName(entity.getClass()));
        int i = 0;
        while (i < listFields.size()) {
            FieldColumnMapper fieldColumnMapper = listFields.get(i);
            logger.trace("fieldColumnMapper {} ", (Object)fieldColumnMapper);
            if (fieldColumnMapper.getColumnAnnotation().insertable()) {
                if (fieldColumnMapper.getColumnDefault() != null) {
                    sql.VALUES(fieldColumnMapper.getColumnName(), fieldColumnMapper.getColumnDefault().value());
                } else if (fieldColumnMapper.isLogicDelete()) {
                    sql.VALUES(fieldColumnMapper.getColumnName(), "'" + fieldColumnMapper.getSoftDelete().value() + "'");
                } else if ((fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || fieldColumnMapper.getFieldType().startsWith("byte") || BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == null) && StringUtils.isBlank((CharSequence)((String)BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()))) && !fieldColumnMapper.isGenerated()) {
                    logger.trace("skip  {} ({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getColumnName());
                } else if (fieldColumnMapper.isGenerated() && fieldColumnMapper.getTemporalAnnotation() != null) {
                    sql.VALUES(fieldColumnMapper.getColumnName(), "'" + DateConverter.convert(entity, fieldColumnMapper, false) + "'");
                } else if (fieldColumnMapper.isGenerated() && (BeanUtil.get(entity, fieldColumnMapper.getFieldName()) == null || StringUtils.isBlank((CharSequence)BeanUtil.get(entity, fieldColumnMapper.getFieldName()).toString()))) {
                    this.generatedValue(sql, entity, fieldColumnMapper);
                } else {
                    sql.VALUES(fieldColumnMapper.getColumnName(), "#{%s}".formatted(fieldColumnMapper.getFieldName()));
                }
            }
            ++i;
        }
        logger.trace("Insert SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    private void generatedValue(SQL sql, T entity, FieldColumnMapper fieldColumnMapper) {
        GeneratedValue generatedValue = fieldColumnMapper.getGeneratedValue();
        if (generatedValue == null || generatedValue.strategy() == GenerationType.AUTO) {
            String genValue = "";
            genValue = generatedValue == null ? IdentifierGeneratorFactory.generate("default") : (IdentifierGeneratorFactory.exists(generatedValue.generator()) ? IdentifierGeneratorFactory.generate(generatedValue.generator()) : IdentifierGeneratorFactory.generate("default"));
            BeanUtil.set(entity, fieldColumnMapper.getFieldName(), genValue);
            sql.VALUES(fieldColumnMapper.getColumnName(), "#{%s}".formatted(fieldColumnMapper.getFieldName()));
        } else if (generatedValue.strategy() == GenerationType.SEQUENCE) {
            sql.VALUES(fieldColumnMapper.getColumnName(), generatedValue.generator() + ".nextval");
        } else if (generatedValue.strategy() != GenerationType.IDENTITY) {
            generatedValue.strategy();
        }
    }
}

