/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.meta.FieldColumnMapper;
import org.dromara.mybatis.jpa.meta.FieldMetadata;
import org.dromara.mybatis.jpa.meta.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(FetchProvider.class);

    public String fetch(Map<String, Object> parametersMap) {
        JpaEntity entity = (JpaEntity)parametersMap.get("entity");
        FieldMetadata.buildColumnList(entity.getClass());
        List<FieldColumnMapper> listFields = FieldMetadata.getFieldsMap(entity.getClass());
        String[] column = new String[listFields.size()];
        int i = 0;
        while (i < listFields.size()) {
            column[i] = listFields.get(i).getColumnName();
            ++i;
        }
        SQL sql = (SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entity.getClass()));
        StringBuffer conditions = new StringBuffer();
        for (FieldColumnMapper fieldColumnMapper : listFields) {
            Object fieldValue = BeanUtil.getValue(entity, fieldColumnMapper.getFieldName());
            String fieldType = fieldColumnMapper.getFieldType();
            logger.trace("Field {} , Type {} , Value {}", new Object[]{fieldColumnMapper.getFieldName(), fieldColumnMapper.getFieldType(), fieldValue});
            if (fieldValue == null || fieldValue.toString().equalsIgnoreCase("null") || fieldType.startsWith("byte")) {
                logger.trace("skip {}({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldType);
                continue;
            }
            if (fieldType.equalsIgnoreCase("String") && StringUtils.isBlank((CharSequence)((String)fieldValue))) {
                logger.trace("skip {}({}) is Blank ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldType);
                continue;
            }
            if (!conditions.isEmpty()) {
                conditions.append(" and ");
            }
            if (fieldColumnMapper.isLogicDelete()) {
                conditions.append(" %s = '%s' ".formatted(fieldColumnMapper.getColumnName(), fieldColumnMapper.getSoftDelete().value()));
                continue;
            }
            conditions.append(" %s = #{%s.%s} ".formatted(fieldColumnMapper.getColumnName(), "entity", fieldColumnMapper.getFieldName()));
        }
        sql.WHERE(conditions.toString());
        logger.trace("Query Page SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    public String fetchByQuery(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        Query condition = (Query)parametersMap.get("condition");
        FieldMetadata.buildColumnList(entityClass);
        List<FieldColumnMapper> listFields = FieldMetadata.getFieldsMap(entityClass);
        String[] column = new String[listFields.size()];
        int i = 0;
        while (i < listFields.size()) {
            column[i] = listFields.get(i).getColumnName();
            ++i;
        }
        SQL sql = (SQL)((SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entityClass))).WHERE("( " + QueryBuilder.build(condition) + " ) ");
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" ( %s = '%s' )".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        logger.trace("query Page By Query SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    public String fetchByLambdaQuery(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        LambdaQuery condition = (LambdaQuery)parametersMap.get("condition");
        FieldMetadata.buildColumnList(entityClass);
        List<FieldColumnMapper> listFields = FieldMetadata.getFieldsMap(entityClass);
        String[] column = new String[listFields.size()];
        int i = 0;
        while (i < listFields.size()) {
            column[i] = listFields.get(i).getColumnName();
            ++i;
        }
        SQL sql = (SQL)((SQL)((SQL)new SQL().SELECT(column)).FROM(TableMetadata.getTableName(entityClass))).WHERE("( " + LambdaQueryBuilder.build(condition) + " ) ");
        FieldColumnMapper logicColumnMapper = FieldMetadata.getLogicColumn(entityClass);
        if (logicColumnMapper != null && logicColumnMapper.isLogicDelete()) {
            sql.WHERE(" ( %s = '%s' )".formatted(logicColumnMapper.getColumnName(), logicColumnMapper.getSoftDelete().value()));
        }
        logger.trace("query Page By LambdaQuery SQL : \n{}", (Object)sql);
        return sql.toString();
    }
}

