/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.spring;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.LocalDateTime;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class MybatisJpaContext {
    static final Logger logger = LoggerFactory.getLogger(MybatisJpaContext.class);
    static StandardEnvironment properties;
    static ApplicationContext jpaContext;
    static String propertyConfigurerBeanName;

    private MybatisJpaContext() {
    }

    public static void init(ApplicationContext applicationContext) {
        jpaContext = applicationContext;
        if (jpaContext.containsBean(propertyConfigurerBeanName)) {
            logger.trace("init MybatisJpaContext properties");
            PropertySourcesPlaceholderConfigurer propertyConfigurer = (PropertySourcesPlaceholderConfigurer)applicationContext.getBean(propertyConfigurerBeanName);
            properties = (StandardEnvironment)propertyConfigurer.getAppliedPropertySources().get("environmentProperties").getSource();
        }
    }

    public static ApplicationContext getApplicationContext() {
        HttpSession session = MybatisJpaContext.getSession();
        return session == null ? null : WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
    }

    public static Object getBean(String id) {
        if (jpaContext == null) {
            ApplicationContext applicationContext = MybatisJpaContext.getApplicationContext();
            return applicationContext == null ? null : applicationContext.getBean(id);
        }
        return jpaContext.getBean(id);
    }

    public static <T> T getBean(Class<T> requiredType) {
        if (jpaContext == null) {
            ApplicationContext applicationContext = MybatisJpaContext.getApplicationContext();
            return (T)(applicationContext == null ? null : applicationContext.getBean(requiredType));
        }
        return (T)jpaContext.getBean(requiredType);
    }

    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        if (jpaContext == null) {
            ApplicationContext applicationContext = MybatisJpaContext.getApplicationContext();
            return (T)(applicationContext == null ? null : applicationContext.getBean(name, requiredType));
        }
        return (T)jpaContext.getBean(name, requiredType);
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes == null ? null : servletRequestAttributes.getRequest();
    }

    public static HttpSession getSession() {
        HttpServletRequest request = MybatisJpaContext.getRequest();
        return request == null ? null : request.getSession();
    }

    public static StandardEnvironment getProperties() {
        return properties;
    }

    public static ApplicationContext getJpaContext() {
        return jpaContext;
    }

    public static String version() {
        return String.format("---------------------------------------------------------------------------------\n-              JAVA\n-              %s java version %s, class %s\n-              %s (build %s, %s)\n---------------------------------------------------------------------------------\n-                                MyBatis JPA Extra\n-\n-              %sCopyright 2018 - %s https://gitee.com/dromara/mybatis-jpa-extra/\n-\n-              Licensed under the Apache License, Version 2.0\n---------------------------------------------------------------------------------\n", SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_VERSION, SystemUtils.JAVA_CLASS_VERSION, SystemUtils.JAVA_VM_NAME, SystemUtils.JAVA_VM_VERSION, SystemUtils.JAVA_VM_INFO, Character.valueOf('\u00a9'), LocalDateTime.now().getYear());
    }

    static {
        propertyConfigurerBeanName = "propertySourcesPlaceholderConfigurer";
    }
}

