/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPageResults<T> {
    private final Logger _logger = LoggerFactory.getLogger(JpaPageResults.class);
    private int page = 0;
    private int total = 0;
    private int totalPage = 0;
    private Long records = 0L;
    private List<T> rows;

    public JpaPageResults() {
        this._logger.debug("Grid.");
    }

    public JpaPageResults(int currentPage, int pageResults, Long recordsCount) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this._logger.debug("JpaPageResults : {} , records : {} , total : {}", new Object[]{this.page, this.records, this.total});
    }

    public JpaPageResults(int currentPage, int pageResults, Long recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
    }

    public JpaPageResults(int currentPage, int pageResults, Integer recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
    }

    public JpaPageResults(int currentPage, int pageResults, int totalPage, Long recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
        this.totalPage = totalPage;
    }

    public JpaPageResults(int currentPage, int pageResults, int totalPage, Integer recordsCount, List<T> rows) {
        this.pageCount(currentPage, pageResults, recordsCount);
        this.rows = rows;
        this.totalPage = totalPage;
    }

    public void pageCount(int currentPage, int pageResults, Long recordsCount) {
        this.page = currentPage;
        this.total = (int)(recordsCount % (long)pageResults > 0L ? recordsCount / (long)pageResults + 1L : recordsCount / (long)pageResults);
        this.records = recordsCount;
    }

    public void pageCount(int currentPage, int pageResults, Integer recordsCount) {
        this.page = currentPage;
        this.total = recordsCount % pageResults > 0 ? recordsCount / pageResults + 1 : recordsCount / pageResults;
        this.records = Long.parseLong("" + recordsCount);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public Long getRecords() {
        return this.records;
    }

    public void setRecords(Long records) {
        this.records = records;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JpaPageResults [_logger=");
        builder.append(this._logger);
        builder.append(", page=");
        builder.append(this.page);
        builder.append(", total=");
        builder.append(this.total);
        builder.append(", totalPage=");
        builder.append(this.totalPage);
        builder.append(", records=");
        builder.append(this.records);
        builder.append(", rows=");
        builder.append(this.rows);
        builder.append("]");
        return builder.toString();
    }
}

