/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.password.AbstractDictionaryRule;

public class DictionarySubstringRule
extends AbstractDictionaryRule {
    public static final int DEFAULT_WORD_LENGTH = 4;
    private int wordLength = 4;

    public DictionarySubstringRule() {
    }

    public DictionarySubstringRule(Dictionary dict) {
        this.dictionary = dict;
    }

    public DictionarySubstringRule(Dictionary dict, int n) {
        this.setDictionary(dict);
        this.setWordLength(n);
    }

    public void setWordLength(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("wordLength must be >= 1");
        }
        this.wordLength = n;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    @Override
    protected String doWordSearch(String text) {
        for (int i = this.wordLength; i <= text.length(); ++i) {
            int j = 0;
            while (j + i <= text.length()) {
                String s = text.substring(j, j + i);
                if (this.dictionary.search(s)) {
                    return s;
                }
                ++j;
            }
        }
        return null;
    }
}

